/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.Project;
import software.amazon.awssdk.services.codebuild.model.ProjectNamesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetProjectsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetProjectsResponse> {
    private static final SdkField<List<Project>> PROJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projects").getter(BatchGetProjectsResponse.getter(BatchGetProjectsResponse::projects)).setter(BatchGetProjectsResponse.setter(Builder::projects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Project::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROJECTS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectsNotFound").getter(BatchGetProjectsResponse.getter(BatchGetProjectsResponse::projectsNotFound)).setter(BatchGetProjectsResponse.setter(Builder::projectsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD, PROJECTS_NOT_FOUND_FIELD));
    private final List<Project> projects;
    private final List<String> projectsNotFound;

    private BatchGetProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.projectsNotFound = builder.projectsNotFound;
    }

    public final boolean hasProjects() {
        return this.projects != null && !(this.projects instanceof SdkAutoConstructList);
    }

    public final List<Project> projects() {
        return this.projects;
    }

    public final boolean hasProjectsNotFound() {
        return this.projectsNotFound != null && !(this.projectsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> projectsNotFound() {
        return this.projectsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjects() ? this.projects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectsNotFound() ? this.projectsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProjectsResponse)) {
            return false;
        }
        BatchGetProjectsResponse other = (BatchGetProjectsResponse)((Object)obj);
        return this.hasProjects() == other.hasProjects() && Objects.equals(this.projects(), other.projects()) && this.hasProjectsNotFound() == other.hasProjectsNotFound() && Objects.equals(this.projectsNotFound(), other.projectsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetProjectsResponse").add("Projects", this.hasProjects() ? this.projects() : null).add("ProjectsNotFound", this.hasProjectsNotFound() ? this.projectsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projects": {
                return Optional.ofNullable(clazz.cast(this.projects()));
            }
            case "projectsNotFound": {
                return Optional.ofNullable(clazz.cast(this.projectsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetProjectsResponse, T> g) {
        return obj -> g.apply((BatchGetProjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Project> projects = DefaultSdkAutoConstructList.getInstance();
        private List<String> projectsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProjectsResponse model) {
            super(model);
            this.projects(model.projects);
            this.projectsNotFound(model.projectsNotFound);
        }

        public final Collection<Project.Builder> getProjects() {
            if (this.projects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projects != null ? (Collection)this.projects.stream().map(Project::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project ... projects) {
            this.projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<Project.Builder> ... projects) {
            this.projects(Stream.of(projects).map(c -> (Project)((Project.Builder)Project.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjects(Collection<Project.BuilderImpl> projects) {
            this.projects = ProjectsCopier.copyFromBuilder(projects);
        }

        public final Collection<String> getProjectsNotFound() {
            if (this.projectsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projectsNotFound;
        }

        @Override
        public final Builder projectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectsNotFound(String ... projectsNotFound) {
            this.projectsNotFound(Arrays.asList(projectsNotFound));
            return this;
        }

        public final void setProjectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
        }

        @Override
        public BatchGetProjectsResponse build() {
            return new BatchGetProjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetProjectsResponse> {
        public Builder projects(Collection<Project> var1);

        public Builder projects(Project ... var1);

        public Builder projects(Consumer<Project.Builder> ... var1);

        public Builder projectsNotFound(Collection<String> var1);

        public Builder projectsNotFound(String ... var1);
    }
}

