/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum;
import software.amazon.awssdk.services.codecommit.model.MergeOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeOptionsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetMergeOptionsResponse> {
    private static final SdkField<List<String>> MERGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mergeOptions").getter(GetMergeOptionsResponse.getter(GetMergeOptionsResponse::mergeOptionsAsStrings)).setter(GetMergeOptionsResponse.setter(Builder::mergeOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitId").getter(GetMergeOptionsResponse.getter(GetMergeOptionsResponse::sourceCommitId)).setter(GetMergeOptionsResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitId").getter(GetMergeOptionsResponse.getter(GetMergeOptionsResponse::destinationCommitId)).setter(GetMergeOptionsResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseCommitId").getter(GetMergeOptionsResponse.getter(GetMergeOptionsResponse::baseCommitId)).setter(GetMergeOptionsResponse.setter(Builder::baseCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_OPTIONS_FIELD, SOURCE_COMMIT_ID_FIELD, DESTINATION_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMergeOptionsResponse.memberNameToFieldInitializer();
    private final List<String> mergeOptions;
    private final String sourceCommitId;
    private final String destinationCommitId;
    private final String baseCommitId;

    private GetMergeOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.mergeOptions = builder.mergeOptions;
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    public final List<MergeOptionTypeEnum> mergeOptions() {
        return MergeOptionsCopier.copyStringToEnum(this.mergeOptions);
    }

    public final boolean hasMergeOptions() {
        return this.mergeOptions != null && !(this.mergeOptions instanceof SdkAutoConstructList);
    }

    public final List<String> mergeOptionsAsStrings() {
        return this.mergeOptions;
    }

    public final String sourceCommitId() {
        return this.sourceCommitId;
    }

    public final String destinationCommitId() {
        return this.destinationCommitId;
    }

    public final String baseCommitId() {
        return this.baseCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMergeOptions() ? this.mergeOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCommitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeOptionsResponse)) {
            return false;
        }
        GetMergeOptionsResponse other = (GetMergeOptionsResponse)((Object)obj);
        return this.hasMergeOptions() == other.hasMergeOptions() && Objects.equals(this.mergeOptionsAsStrings(), other.mergeOptionsAsStrings()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.baseCommitId(), other.baseCommitId());
    }

    public final String toString() {
        return ToString.builder((String)"GetMergeOptionsResponse").add("MergeOptions", this.hasMergeOptions() ? this.mergeOptionsAsStrings() : null).add("SourceCommitId", (Object)this.sourceCommitId()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("BaseCommitId", (Object)this.baseCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mergeOptions": {
                return Optional.ofNullable(clazz.cast(this.mergeOptionsAsStrings()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "baseCommitId": {
                return Optional.ofNullable(clazz.cast(this.baseCommitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mergeOptions", MERGE_OPTIONS_FIELD);
        map.put("sourceCommitId", SOURCE_COMMIT_ID_FIELD);
        map.put("destinationCommitId", DESTINATION_COMMIT_ID_FIELD);
        map.put("baseCommitId", BASE_COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMergeOptionsResponse, T> g) {
        return obj -> g.apply((GetMergeOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> mergeOptions = DefaultSdkAutoConstructList.getInstance();
        private String sourceCommitId;
        private String destinationCommitId;
        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeOptionsResponse model) {
            super(model);
            this.mergeOptionsWithStrings(model.mergeOptions);
            this.sourceCommitId(model.sourceCommitId);
            this.destinationCommitId(model.destinationCommitId);
            this.baseCommitId(model.baseCommitId);
        }

        public final Collection<String> getMergeOptions() {
            if (this.mergeOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mergeOptions;
        }

        public final void setMergeOptions(Collection<String> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copy(mergeOptions);
        }

        @Override
        public final Builder mergeOptionsWithStrings(Collection<String> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copy(mergeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeOptionsWithStrings(String ... mergeOptions) {
            this.mergeOptionsWithStrings(Arrays.asList(mergeOptions));
            return this;
        }

        @Override
        public final Builder mergeOptions(Collection<MergeOptionTypeEnum> mergeOptions) {
            this.mergeOptions = MergeOptionsCopier.copyEnumToString(mergeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeOptions(MergeOptionTypeEnum ... mergeOptions) {
            this.mergeOptions(Arrays.asList(mergeOptions));
            return this;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getBaseCommitId() {
            return this.baseCommitId;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        @Override
        public GetMergeOptionsResponse build() {
            return new GetMergeOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeOptionsResponse> {
        public Builder mergeOptionsWithStrings(Collection<String> var1);

        public Builder mergeOptionsWithStrings(String ... var1);

        public Builder mergeOptions(Collection<MergeOptionTypeEnum> var1);

        public Builder mergeOptions(MergeOptionTypeEnum ... var1);

        public Builder sourceCommitId(String var1);

        public Builder destinationCommitId(String var1);

        public Builder baseCommitId(String var1);
    }
}

