/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectTypes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectTypes> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ObjectTypes.getter(ObjectTypes::sourceAsString)).setter(ObjectTypes.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(ObjectTypes.getter(ObjectTypes::destinationAsString)).setter(ObjectTypes.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("base").getter(ObjectTypes.getter(ObjectTypes::baseAsString)).setter(ObjectTypes.setter(Builder::base)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, BASE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectTypes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String destination;
    private final String base;

    private ObjectTypes(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    public final ObjectTypeEnum source() {
        return ObjectTypeEnum.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final ObjectTypeEnum destination() {
        return ObjectTypeEnum.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final ObjectTypeEnum base() {
        return ObjectTypeEnum.fromValue(this.base);
    }

    public final String baseAsString() {
        return this.base;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypes)) {
            return false;
        }
        ObjectTypes other = (ObjectTypes)obj;
        return Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.baseAsString(), other.baseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectTypes").add("Source", (Object)this.sourceAsString()).add("Destination", (Object)this.destinationAsString()).add("Base", (Object)this.baseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "base": {
                return Optional.ofNullable(clazz.cast(this.baseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("base", BASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectTypes, T> g) {
        return obj -> g.apply((ObjectTypes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String destination;
        private String base;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectTypes model) {
            this.source(model.source);
            this.destination(model.destination);
            this.base(model.base);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(ObjectTypeEnum source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(ObjectTypeEnum destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getBase() {
            return this.base;
        }

        public final void setBase(String base) {
            this.base = base;
        }

        @Override
        public final Builder base(String base) {
            this.base = base;
            return this;
        }

        @Override
        public final Builder base(ObjectTypeEnum base) {
            this.base(base == null ? null : base.toString());
            return this;
        }

        public ObjectTypes build() {
            return new ObjectTypes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectTypes> {
        public Builder source(String var1);

        public Builder source(ObjectTypeEnum var1);

        public Builder destination(String var1);

        public Builder destination(ObjectTypeEnum var1);

        public Builder base(String var1);

        public Builder base(ObjectTypeEnum var1);
    }
}

