/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentInfo implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentInfo.Builder, DeploymentInfo> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(DeploymentInfo::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupName").getter(getter(DeploymentInfo::deploymentGroupName))
            .setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentConfigName").getter(getter(DeploymentInfo::deploymentConfigName))
            .setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(DeploymentInfo::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<RevisionLocation> PREVIOUS_REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).memberName("previousRevision")
            .getter(getter(DeploymentInfo::previousRevision)).setter(setter(Builder::previousRevision))
            .constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousRevision").build()).build();

    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).memberName("revision").getter(getter(DeploymentInfo::revision))
            .setter(setter(Builder::revision)).constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeploymentInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorInformation> ERROR_INFORMATION_FIELD = SdkField
            .<ErrorInformation> builder(MarshallingType.SDK_POJO).memberName("errorInformation")
            .getter(getter(DeploymentInfo::errorInformation)).setter(setter(Builder::errorInformation))
            .constructor(ErrorInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInformation").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(DeploymentInfo::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DeploymentInfo::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> COMPLETE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completeTime").getter(getter(DeploymentInfo::completeTime)).setter(setter(Builder::completeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completeTime").build()).build();

    private static final SdkField<DeploymentOverview> DEPLOYMENT_OVERVIEW_FIELD = SdkField
            .<DeploymentOverview> builder(MarshallingType.SDK_POJO).memberName("deploymentOverview")
            .getter(getter(DeploymentInfo::deploymentOverview)).setter(setter(Builder::deploymentOverview))
            .constructor(DeploymentOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOverview").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DeploymentInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CREATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("creator")
            .getter(getter(DeploymentInfo::creatorAsString)).setter(setter(Builder::creator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creator").build()).build();

    private static final SdkField<Boolean> IGNORE_APPLICATION_STOP_FAILURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreApplicationStopFailures")
            .getter(getter(DeploymentInfo::ignoreApplicationStopFailures))
            .setter(setter(Builder::ignoreApplicationStopFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreApplicationStopFailures")
                    .build()).build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration")
            .getter(getter(DeploymentInfo::autoRollbackConfiguration)).setter(setter(Builder::autoRollbackConfiguration))
            .constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<Boolean> UPDATE_OUTDATED_INSTANCES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("updateOutdatedInstancesOnly")
            .getter(getter(DeploymentInfo::updateOutdatedInstancesOnly))
            .setter(setter(Builder::updateOutdatedInstancesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateOutdatedInstancesOnly")
                    .build()).build();

    private static final SdkField<RollbackInfo> ROLLBACK_INFO_FIELD = SdkField.<RollbackInfo> builder(MarshallingType.SDK_POJO)
            .memberName("rollbackInfo").getter(getter(DeploymentInfo::rollbackInfo)).setter(setter(Builder::rollbackInfo))
            .constructor(RollbackInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackInfo").build()).build();

    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField
            .<DeploymentStyle> builder(MarshallingType.SDK_POJO).memberName("deploymentStyle")
            .getter(getter(DeploymentInfo::deploymentStyle)).setter(setter(Builder::deploymentStyle))
            .constructor(DeploymentStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()).build();

    private static final SdkField<TargetInstances> TARGET_INSTANCES_FIELD = SdkField
            .<TargetInstances> builder(MarshallingType.SDK_POJO).memberName("targetInstances")
            .getter(getter(DeploymentInfo::targetInstances)).setter(setter(Builder::targetInstances))
            .constructor(TargetInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstances").build()).build();

    private static final SdkField<Boolean> INSTANCE_TERMINATION_WAIT_TIME_STARTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("instanceTerminationWaitTimeStarted")
            .getter(getter(DeploymentInfo::instanceTerminationWaitTimeStarted))
            .setter(setter(Builder::instanceTerminationWaitTimeStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTerminationWaitTimeStarted")
                    .build()).build();

    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<BlueGreenDeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("blueGreenDeploymentConfiguration")
            .getter(getter(DeploymentInfo::blueGreenDeploymentConfiguration))
            .setter(setter(Builder::blueGreenDeploymentConfiguration))
            .constructor(BlueGreenDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration")
                    .build()).build();

    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField
            .<LoadBalancerInfo> builder(MarshallingType.SDK_POJO).memberName("loadBalancerInfo")
            .getter(getter(DeploymentInfo::loadBalancerInfo)).setter(setter(Builder::loadBalancerInfo))
            .constructor(LoadBalancerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()).build();

    private static final SdkField<String> ADDITIONAL_DEPLOYMENT_STATUS_INFO_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("additionalDeploymentStatusInfo")
            .getter(getter(DeploymentInfo::additionalDeploymentStatusInfo))
            .setter(setter(Builder::additionalDeploymentStatusInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalDeploymentStatusInfo")
                    .build()).build();

    private static final SdkField<String> FILE_EXISTS_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileExistsBehavior").getter(getter(DeploymentInfo::fileExistsBehaviorAsString))
            .setter(setter(Builder::fileExistsBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExistsBehavior").build())
            .build();

    private static final SdkField<List<String>> DEPLOYMENT_STATUS_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deploymentStatusMessages")
            .getter(getter(DeploymentInfo::deploymentStatusMessages))
            .setter(setter(Builder::deploymentStatusMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computePlatform").getter(getter(DeploymentInfo::computePlatformAsString))
            .setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(DeploymentInfo::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<RelatedDeployments> RELATED_DEPLOYMENTS_FIELD = SdkField
            .<RelatedDeployments> builder(MarshallingType.SDK_POJO).memberName("relatedDeployments")
            .getter(getter(DeploymentInfo::relatedDeployments)).setter(setter(Builder::relatedDeployments))
            .constructor(RelatedDeployments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedDeployments").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, DEPLOYMENT_ID_FIELD, PREVIOUS_REVISION_FIELD,
            REVISION_FIELD, STATUS_FIELD, ERROR_INFORMATION_FIELD, CREATE_TIME_FIELD, START_TIME_FIELD, COMPLETE_TIME_FIELD,
            DEPLOYMENT_OVERVIEW_FIELD, DESCRIPTION_FIELD, CREATOR_FIELD, IGNORE_APPLICATION_STOP_FAILURES_FIELD,
            AUTO_ROLLBACK_CONFIGURATION_FIELD, UPDATE_OUTDATED_INSTANCES_ONLY_FIELD, ROLLBACK_INFO_FIELD, DEPLOYMENT_STYLE_FIELD,
            TARGET_INSTANCES_FIELD, INSTANCE_TERMINATION_WAIT_TIME_STARTED_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD,
            LOAD_BALANCER_INFO_FIELD, ADDITIONAL_DEPLOYMENT_STATUS_INFO_FIELD, FILE_EXISTS_BEHAVIOR_FIELD,
            DEPLOYMENT_STATUS_MESSAGES_FIELD, COMPUTE_PLATFORM_FIELD, EXTERNAL_ID_FIELD, RELATED_DEPLOYMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String deploymentGroupName;

    private final String deploymentConfigName;

    private final String deploymentId;

    private final RevisionLocation previousRevision;

    private final RevisionLocation revision;

    private final String status;

    private final ErrorInformation errorInformation;

    private final Instant createTime;

    private final Instant startTime;

    private final Instant completeTime;

    private final DeploymentOverview deploymentOverview;

    private final String description;

    private final String creator;

    private final Boolean ignoreApplicationStopFailures;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final Boolean updateOutdatedInstancesOnly;

    private final RollbackInfo rollbackInfo;

    private final DeploymentStyle deploymentStyle;

    private final TargetInstances targetInstances;

    private final Boolean instanceTerminationWaitTimeStarted;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final String additionalDeploymentStatusInfo;

    private final String fileExistsBehavior;

    private final List<String> deploymentStatusMessages;

    private final String computePlatform;

    private final String externalId;

    private final RelatedDeployments relatedDeployments;

    private DeploymentInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.deploymentId = builder.deploymentId;
        this.previousRevision = builder.previousRevision;
        this.revision = builder.revision;
        this.status = builder.status;
        this.errorInformation = builder.errorInformation;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.deploymentOverview = builder.deploymentOverview;
        this.description = builder.description;
        this.creator = builder.creator;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.rollbackInfo = builder.rollbackInfo;
        this.deploymentStyle = builder.deploymentStyle;
        this.targetInstances = builder.targetInstances;
        this.instanceTerminationWaitTimeStarted = builder.instanceTerminationWaitTimeStarted;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.additionalDeploymentStatusInfo = builder.additionalDeploymentStatusInfo;
        this.fileExistsBehavior = builder.fileExistsBehavior;
        this.deploymentStatusMessages = builder.deploymentStatusMessages;
        this.computePlatform = builder.computePlatform;
        this.externalId = builder.externalId;
        this.relatedDeployments = builder.relatedDeployments;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment group name.
     * </p>
     * 
     * @return The deployment group name.
     */
    public final String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public final String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Information about the application revision that was deployed to the deployment group before the most recent
     * successful deployment.
     * </p>
     * 
     * @return Information about the application revision that was deployed to the deployment group before the most
     *         recent successful deployment.
     */
    public final RevisionLocation previousRevision() {
        return previousRevision;
    }

    /**
     * <p>
     * Information about the location of stored application artifacts and the service from which to retrieve them.
     * </p>
     * 
     * @return Information about the location of stored application artifacts and the service from which to retrieve
     *         them.
     */
    public final RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * The current state of the deployment as a whole.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the deployment as a whole.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the deployment as a whole.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the deployment as a whole.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about any error associated with this deployment.
     * </p>
     * 
     * @return Information about any error associated with this deployment.
     */
    public final ErrorInformation errorInformation() {
        return errorInformation;
    }

    /**
     * <p>
     * A timestamp that indicates when the deployment was created.
     * </p>
     * 
     * @return A timestamp that indicates when the deployment was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the deployment was deployed to the deployment group.
     * </p>
     * <p>
     * In some cases, the reported value of the start time might be later than the complete time. This is due to
     * differences in the clock settings of backend servers that participate in the deployment process.
     * </p>
     * 
     * @return A timestamp that indicates when the deployment was deployed to the deployment group.</p>
     *         <p>
     *         In some cases, the reported value of the start time might be later than the complete time. This is due to
     *         differences in the clock settings of backend servers that participate in the deployment process.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the deployment was complete.
     * </p>
     * 
     * @return A timestamp that indicates when the deployment was complete.
     */
    public final Instant completeTime() {
        return completeTime;
    }

    /**
     * <p>
     * A summary of the deployment status of the instances in the deployment.
     * </p>
     * 
     * @return A summary of the deployment status of the instances in the deployment.
     */
    public final DeploymentOverview deploymentOverview() {
        return deploymentOverview;
    }

    /**
     * <p>
     * A comment about the deployment.
     * </p>
     * 
     * @return A comment about the deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The means by which the deployment was created:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>user</code>: A user created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>codeDeployRollback</code>: A rollback process created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2
     * instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creator} will
     * return {@link DeploymentCreator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #creatorAsString}.
     * </p>
     * 
     * @return The means by which the deployment was created:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>user</code>: A user created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>codeDeployRollback</code>: A rollback process created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected
     *         outdated EC2 instances.
     *         </p>
     *         </li>
     * @see DeploymentCreator
     */
    public final DeploymentCreator creator() {
        return DeploymentCreator.fromValue(creator);
    }

    /**
     * <p>
     * The means by which the deployment was created:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>user</code>: A user created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>codeDeployRollback</code>: A rollback process created the deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated EC2
     * instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creator} will
     * return {@link DeploymentCreator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #creatorAsString}.
     * </p>
     * 
     * @return The means by which the deployment was created:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>user</code>: A user created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>codeDeployRollback</code>: A rollback process created the deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected
     *         outdated EC2 instances.
     *         </p>
     *         </li>
     * @see DeploymentCreator
     */
    public final String creatorAsString() {
        return creator;
    }

    /**
     * <p>
     * If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
     * <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to
     * the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues
     * with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with
     * <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with
     * <code>ApplicationStop</code>.
     * </p>
     * <p>
     * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment
     * fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not
     * less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
     * </p>
     * <p>
     * During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
     * <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous
     * successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of
     * these scripts contains an error and does not run successfully, the deployment can fail.
     * </p>
     * <p>
     * If the cause of the failure is a script from the last successful deployment that will never run successfully,
     * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the
     * <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should
     * be ignored.
     * </p>
     * 
     * @return If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
     *         <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment
     *         continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the
     *         deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment
     *         continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment
     *         continues with <code>ApplicationStop</code>. </p>
     *         <p>
     *         If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
     *         deployment fails. If deployment to that instance is part of an overall deployment and the number of
     *         healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
     *         instance is attempted.
     *         </p>
     *         <p>
     *         During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the
     *         previous successful deployment. (All other scripts are run from the AppSpec file in the current
     *         deployment.) If one of these scripts contains an error and does not run successfully, the deployment can
     *         fail.
     *         </p>
     *         <p>
     *         If the cause of the failure is a script from the last successful deployment that will never run
     *         successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that
     *         the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code>
     *         failures should be ignored.
     */
    public final Boolean ignoreApplicationStopFailures() {
        return ignoreApplicationStopFailures;
    }

    /**
     * <p>
     * Information about the automatic rollback configuration associated with the deployment.
     * </p>
     * 
     * @return Information about the automatic rollback configuration associated with the deployment.
     */
    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates whether only instances that are not running the latest application revision are to be deployed to.
     * </p>
     * 
     * @return Indicates whether only instances that are not running the latest application revision are to be deployed
     *         to.
     */
    public final Boolean updateOutdatedInstancesOnly() {
        return updateOutdatedInstancesOnly;
    }

    /**
     * <p>
     * Information about a deployment rollback.
     * </p>
     * 
     * @return Information about a deployment rollback.
     */
    public final RollbackInfo rollbackInfo() {
        return rollbackInfo;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public final DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public final TargetInstances targetInstances() {
        return targetInstances;
    }

    /**
     * <p>
     * Indicates whether the wait period set for the termination of instances in the original environment has started.
     * Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the termination wait period
     * starts.
     * </p>
     * 
     * @return Indicates whether the wait period set for the termination of instances in the original environment has
     *         started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the
     *         termination wait period starts.
     */
    public final Boolean instanceTerminationWaitTimeStarted() {
        return instanceTerminationWaitTimeStarted;
    }

    /**
     * <p>
     * Information about blue/green deployment options for this deployment.
     * </p>
     * 
     * @return Information about blue/green deployment options for this deployment.
     */
    public final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer used in the deployment.
     * </p>
     * 
     * @return Information about the load balancer used in the deployment.
     */
    public final LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Provides information about the results of a deployment, such as whether instances in the original environment in
     * a blue/green deployment were not terminated.
     * </p>
     * 
     * @return Provides information about the results of a deployment, such as whether instances in the original
     *         environment in a blue/green deployment were not terminated.
     */
    public final String additionalDeploymentStatusInfo() {
        return additionalDeploymentStatusInfo;
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces
     * the version already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
     * deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
     *         replaces the version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
     *         deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public final FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(fileExistsBehavior);
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces
     * the version already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
     * deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
     *         replaces the version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
     *         deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public final String fileExistsBehaviorAsString() {
        return fileExistsBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentStatusMessages property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeploymentStatusMessages() {
        return deploymentStatusMessages != null && !(deploymentStatusMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Messages that contain information about the status of a deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentStatusMessages} method.
     * </p>
     * 
     * @return Messages that contain information about the status of a deployment.
     */
    public final List<String> deploymentStatusMessages() {
        return deploymentStatusMessages;
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this
     * deployment.
     * </p>
     * 
     * @return The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this
     *         deployment.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * Returns the value of the RelatedDeployments property for this object.
     * 
     * @return The value of the RelatedDeployments property for this object.
     */
    public final RelatedDeployments relatedDeployments() {
        return relatedDeployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(previousRevision());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInformation());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOverview());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackInfo());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTerminationWaitTimeStarted());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(additionalDeploymentStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(fileExistsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentStatusMessages() ? deploymentStatusMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(relatedDeployments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(previousRevision(), other.previousRevision()) && Objects.equals(revision(), other.revision())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorInformation(), other.errorInformation())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completeTime(), other.completeTime())
                && Objects.equals(deploymentOverview(), other.deploymentOverview())
                && Objects.equals(description(), other.description())
                && Objects.equals(creatorAsString(), other.creatorAsString())
                && Objects.equals(ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly())
                && Objects.equals(rollbackInfo(), other.rollbackInfo())
                && Objects.equals(deploymentStyle(), other.deploymentStyle())
                && Objects.equals(targetInstances(), other.targetInstances())
                && Objects.equals(instanceTerminationWaitTimeStarted(), other.instanceTerminationWaitTimeStarted())
                && Objects.equals(blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration())
                && Objects.equals(loadBalancerInfo(), other.loadBalancerInfo())
                && Objects.equals(additionalDeploymentStatusInfo(), other.additionalDeploymentStatusInfo())
                && Objects.equals(fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString())
                && hasDeploymentStatusMessages() == other.hasDeploymentStatusMessages()
                && Objects.equals(deploymentStatusMessages(), other.deploymentStatusMessages())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(relatedDeployments(), other.relatedDeployments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentInfo").add("ApplicationName", applicationName())
                .add("DeploymentGroupName", deploymentGroupName()).add("DeploymentConfigName", deploymentConfigName())
                .add("DeploymentId", deploymentId()).add("PreviousRevision", previousRevision()).add("Revision", revision())
                .add("Status", statusAsString()).add("ErrorInformation", errorInformation()).add("CreateTime", createTime())
                .add("StartTime", startTime()).add("CompleteTime", completeTime())
                .add("DeploymentOverview", deploymentOverview()).add("Description", description())
                .add("Creator", creatorAsString()).add("IgnoreApplicationStopFailures", ignoreApplicationStopFailures())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("UpdateOutdatedInstancesOnly", updateOutdatedInstancesOnly()).add("RollbackInfo", rollbackInfo())
                .add("DeploymentStyle", deploymentStyle()).add("TargetInstances", targetInstances())
                .add("InstanceTerminationWaitTimeStarted", instanceTerminationWaitTimeStarted())
                .add("BlueGreenDeploymentConfiguration", blueGreenDeploymentConfiguration())
                .add("LoadBalancerInfo", loadBalancerInfo())
                .add("AdditionalDeploymentStatusInfo", additionalDeploymentStatusInfo())
                .add("FileExistsBehavior", fileExistsBehaviorAsString())
                .add("DeploymentStatusMessages", hasDeploymentStatusMessages() ? deploymentStatusMessages() : null)
                .add("ComputePlatform", computePlatformAsString()).add("ExternalId", externalId())
                .add("RelatedDeployments", relatedDeployments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "previousRevision":
            return Optional.ofNullable(clazz.cast(previousRevision()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorInformation":
            return Optional.ofNullable(clazz.cast(errorInformation()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "completeTime":
            return Optional.ofNullable(clazz.cast(completeTime()));
        case "deploymentOverview":
            return Optional.ofNullable(clazz.cast(deploymentOverview()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creator":
            return Optional.ofNullable(clazz.cast(creatorAsString()));
        case "ignoreApplicationStopFailures":
            return Optional.ofNullable(clazz.cast(ignoreApplicationStopFailures()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "updateOutdatedInstancesOnly":
            return Optional.ofNullable(clazz.cast(updateOutdatedInstancesOnly()));
        case "rollbackInfo":
            return Optional.ofNullable(clazz.cast(rollbackInfo()));
        case "deploymentStyle":
            return Optional.ofNullable(clazz.cast(deploymentStyle()));
        case "targetInstances":
            return Optional.ofNullable(clazz.cast(targetInstances()));
        case "instanceTerminationWaitTimeStarted":
            return Optional.ofNullable(clazz.cast(instanceTerminationWaitTimeStarted()));
        case "blueGreenDeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentConfiguration()));
        case "loadBalancerInfo":
            return Optional.ofNullable(clazz.cast(loadBalancerInfo()));
        case "additionalDeploymentStatusInfo":
            return Optional.ofNullable(clazz.cast(additionalDeploymentStatusInfo()));
        case "fileExistsBehavior":
            return Optional.ofNullable(clazz.cast(fileExistsBehaviorAsString()));
        case "deploymentStatusMessages":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessages()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "relatedDeployments":
            return Optional.ofNullable(clazz.cast(relatedDeployments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentInfo, T> g) {
        return obj -> g.apply((DeploymentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentInfo> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment group name.
         * </p>
         * 
         * @param deploymentGroupName
         *        The deployment group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Information about the application revision that was deployed to the deployment group before the most recent
         * successful deployment.
         * </p>
         * 
         * @param previousRevision
         *        Information about the application revision that was deployed to the deployment group before the most
         *        recent successful deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousRevision(RevisionLocation previousRevision);

        /**
         * <p>
         * Information about the application revision that was deployed to the deployment group before the most recent
         * successful deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionLocation.Builder} avoiding the
         * need to create one manually via {@link RevisionLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #previousRevision(RevisionLocation)}.
         * 
         * @param previousRevision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousRevision(RevisionLocation)
         */
        default Builder previousRevision(Consumer<RevisionLocation.Builder> previousRevision) {
            return previousRevision(RevisionLocation.builder().applyMutation(previousRevision).build());
        }

        /**
         * <p>
         * Information about the location of stored application artifacts and the service from which to retrieve them.
         * </p>
         * 
         * @param revision
         *        Information about the location of stored application artifacts and the service from which to retrieve
         *        them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * Information about the location of stored application artifacts and the service from which to retrieve them.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionLocation.Builder} avoiding the
         * need to create one manually via {@link RevisionLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(RevisionLocation)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(RevisionLocation)
         */
        default Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return revision(RevisionLocation.builder().applyMutation(revision).build());
        }

        /**
         * <p>
         * The current state of the deployment as a whole.
         * </p>
         * 
         * @param status
         *        The current state of the deployment as a whole.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the deployment as a whole.
         * </p>
         * 
         * @param status
         *        The current state of the deployment as a whole.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * Information about any error associated with this deployment.
         * </p>
         * 
         * @param errorInformation
         *        Information about any error associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInformation(ErrorInformation errorInformation);

        /**
         * <p>
         * Information about any error associated with this deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInformation.Builder} avoiding the
         * need to create one manually via {@link ErrorInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInformation(ErrorInformation)}.
         * 
         * @param errorInformation
         *        a consumer that will call methods on {@link ErrorInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInformation(ErrorInformation)
         */
        default Builder errorInformation(Consumer<ErrorInformation.Builder> errorInformation) {
            return errorInformation(ErrorInformation.builder().applyMutation(errorInformation).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the deployment was created.
         * </p>
         * 
         * @param createTime
         *        A timestamp that indicates when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * A timestamp that indicates when the deployment was deployed to the deployment group.
         * </p>
         * <p>
         * In some cases, the reported value of the start time might be later than the complete time. This is due to
         * differences in the clock settings of backend servers that participate in the deployment process.
         * </p>
         * 
         * @param startTime
         *        A timestamp that indicates when the deployment was deployed to the deployment group.</p>
         *        <p>
         *        In some cases, the reported value of the start time might be later than the complete time. This is due
         *        to differences in the clock settings of backend servers that participate in the deployment process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A timestamp that indicates when the deployment was complete.
         * </p>
         * 
         * @param completeTime
         *        A timestamp that indicates when the deployment was complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeTime(Instant completeTime);

        /**
         * <p>
         * A summary of the deployment status of the instances in the deployment.
         * </p>
         * 
         * @param deploymentOverview
         *        A summary of the deployment status of the instances in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOverview(DeploymentOverview deploymentOverview);

        /**
         * <p>
         * A summary of the deployment status of the instances in the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentOverview.Builder} avoiding the
         * need to create one manually via {@link DeploymentOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentOverview.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentOverview(DeploymentOverview)}.
         * 
         * @param deploymentOverview
         *        a consumer that will call methods on {@link DeploymentOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentOverview(DeploymentOverview)
         */
        default Builder deploymentOverview(Consumer<DeploymentOverview.Builder> deploymentOverview) {
            return deploymentOverview(DeploymentOverview.builder().applyMutation(deploymentOverview).build());
        }

        /**
         * <p>
         * A comment about the deployment.
         * </p>
         * 
         * @param description
         *        A comment about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The means by which the deployment was created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>user</code>: A user created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>codeDeployRollback</code>: A rollback process created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated
         * EC2 instances.
         * </p>
         * </li>
         * </ul>
         * 
         * @param creator
         *        The means by which the deployment was created:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>user</code>: A user created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>codeDeployRollback</code>: A rollback process created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected
         *        outdated EC2 instances.
         *        </p>
         *        </li>
         * @see DeploymentCreator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCreator
         */
        Builder creator(String creator);

        /**
         * <p>
         * The means by which the deployment was created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>user</code>: A user created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>codeDeployRollback</code>: A rollback process created the deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated
         * EC2 instances.
         * </p>
         * </li>
         * </ul>
         * 
         * @param creator
         *        The means by which the deployment was created:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>user</code>: A user created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>codeDeployRollback</code>: A rollback process created the deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected
         *        outdated EC2 instances.
         *        </p>
         *        </li>
         * @see DeploymentCreator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCreator
         */
        Builder creator(DeploymentCreator creator);

        /**
         * <p>
         * If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
         * <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues
         * to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment
         * continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with
         * <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with
         * <code>ApplicationStop</code>.
         * </p>
         * <p>
         * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         * deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy
         * hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is
         * attempted.
         * </p>
         * <p>
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
         * <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous
         * successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of
         * these scripts contains an error and does not run successfully, the deployment can fail.
         * </p>
         * <p>
         * If the cause of the failure is a script from the last successful deployment that will never run successfully,
         * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the
         * <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures
         * should be ignored.
         * </p>
         * 
         * @param ignoreApplicationStopFailures
         *        If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
         *        <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment
         *        continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails,
         *        the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment
         *        continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment
         *        continues with <code>ApplicationStop</code>. </p>
         *        <p>
         *        If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         *        deployment fails. If deployment to that instance is part of an overall deployment and the number of
         *        healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
         *        instance is attempted.
         *        </p>
         *        <p>
         *        During a deployment, the AWS CodeDeploy agent runs the scripts specified for
         *        <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in
         *        the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec
         *        file in the current deployment.) If one of these scripts contains an error and does not run
         *        successfully, the deployment can fail.
         *        </p>
         *        <p>
         *        If the cause of the failure is a script from the last successful deployment that will never run
         *        successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify
         *        that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
         *        <code>AfterBlockTraffic</code> failures should be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information about the automatic rollback configuration associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Indicates whether only instances that are not running the latest application revision are to be deployed to.
         * </p>
         * 
         * @param updateOutdatedInstancesOnly
         *        Indicates whether only instances that are not running the latest application revision are to be
         *        deployed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly);

        /**
         * <p>
         * Information about a deployment rollback.
         * </p>
         * 
         * @param rollbackInfo
         *        Information about a deployment rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackInfo(RollbackInfo rollbackInfo);

        /**
         * <p>
         * Information about a deployment rollback.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollbackInfo.Builder} avoiding the need
         * to create one manually via {@link RollbackInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollbackInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #rollbackInfo(RollbackInfo)}.
         * 
         * @param rollbackInfo
         *        a consumer that will call methods on {@link RollbackInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackInfo(RollbackInfo)
         */
        default Builder rollbackInfo(Consumer<RollbackInfo.Builder> rollbackInfo) {
            return rollbackInfo(RollbackInfo.builder().applyMutation(rollbackInfo).build());
        }

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentStyle.Builder} avoiding the
         * need to create one manually via {@link DeploymentStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentStyle(DeploymentStyle)}.
         * 
         * @param deploymentStyle
         *        a consumer that will call methods on {@link DeploymentStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStyle(DeploymentStyle)
         */
        default Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return deploymentStyle(DeploymentStyle.builder().applyMutation(deploymentStyle).build());
        }

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param targetInstances
         *        Information about the instances that belong to the replacement environment in a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstances targetInstances);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetInstances.Builder} avoiding the
         * need to create one manually via {@link TargetInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetInstances.Builder#build()} is called immediately and its
         * result is passed to {@link #targetInstances(TargetInstances)}.
         * 
         * @param targetInstances
         *        a consumer that will call methods on {@link TargetInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetInstances(TargetInstances)
         */
        default Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return targetInstances(TargetInstances.builder().applyMutation(targetInstances).build());
        }

        /**
         * <p>
         * Indicates whether the wait period set for the termination of instances in the original environment has
         * started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the
         * termination wait period starts.
         * </p>
         * 
         * @param instanceTerminationWaitTimeStarted
         *        Indicates whether the wait period set for the termination of instances in the original environment has
         *        started. Status is 'false' if the KEEP_ALIVE option is specified. Otherwise, 'true' as soon as the
         *        termination wait period starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted);

        /**
         * <p>
         * Information about blue/green deployment options for this deployment.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about blue/green deployment options for this deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlueGreenDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlueGreenDeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlueGreenDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)}.
         * 
         * @param blueGreenDeploymentConfiguration
         *        a consumer that will call methods on {@link BlueGreenDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)
         */
        default Builder blueGreenDeploymentConfiguration(
                Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.builder()
                    .applyMutation(blueGreenDeploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about the load balancer used in the deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer used in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the load balancer used in the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancerInfo.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadBalancerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerInfo(LoadBalancerInfo)}.
         * 
         * @param loadBalancerInfo
         *        a consumer that will call methods on {@link LoadBalancerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerInfo(LoadBalancerInfo)
         */
        default Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return loadBalancerInfo(LoadBalancerInfo.builder().applyMutation(loadBalancerInfo).build());
        }

        /**
         * <p>
         * Provides information about the results of a deployment, such as whether instances in the original environment
         * in a blue/green deployment were not terminated.
         * </p>
         * 
         * @param additionalDeploymentStatusInfo
         *        Provides information about the results of a deployment, such as whether instances in the original
         *        environment in a blue/green deployment were not terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
         * replaces the version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
         * deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is
         *        specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
         *        replaces the version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the
         *        new deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(String fileExistsBehavior);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
         * replaces the version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new
         * deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is
         *        specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed
         *        replaces the version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the
         *        new deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior);

        /**
         * <p>
         * Messages that contain information about the status of a deployment.
         * </p>
         * 
         * @param deploymentStatusMessages
         *        Messages that contain information about the status of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessages(Collection<String> deploymentStatusMessages);

        /**
         * <p>
         * Messages that contain information about the status of a deployment.
         * </p>
         * 
         * @param deploymentStatusMessages
         *        Messages that contain information about the status of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessages(String... deploymentStatusMessages);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this
         * deployment.
         * </p>
         * 
         * @param externalId
         *        The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * Sets the value of the RelatedDeployments property for this object.
         *
         * @param relatedDeployments
         *        The new value for the RelatedDeployments property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedDeployments(RelatedDeployments relatedDeployments);

        /**
         * Sets the value of the RelatedDeployments property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RelatedDeployments.Builder} avoiding the
         * need to create one manually via {@link RelatedDeployments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedDeployments.Builder#build()} is called immediately and its
         * result is passed to {@link #relatedDeployments(RelatedDeployments)}.
         * 
         * @param relatedDeployments
         *        a consumer that will call methods on {@link RelatedDeployments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedDeployments(RelatedDeployments)
         */
        default Builder relatedDeployments(Consumer<RelatedDeployments.Builder> relatedDeployments) {
            return relatedDeployments(RelatedDeployments.builder().applyMutation(relatedDeployments).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private String deploymentConfigName;

        private String deploymentId;

        private RevisionLocation previousRevision;

        private RevisionLocation revision;

        private String status;

        private ErrorInformation errorInformation;

        private Instant createTime;

        private Instant startTime;

        private Instant completeTime;

        private DeploymentOverview deploymentOverview;

        private String description;

        private String creator;

        private Boolean ignoreApplicationStopFailures;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private Boolean updateOutdatedInstancesOnly;

        private RollbackInfo rollbackInfo;

        private DeploymentStyle deploymentStyle;

        private TargetInstances targetInstances;

        private Boolean instanceTerminationWaitTimeStarted;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private String additionalDeploymentStatusInfo;

        private String fileExistsBehavior;

        private List<String> deploymentStatusMessages = DefaultSdkAutoConstructList.getInstance();

        private String computePlatform;

        private String externalId;

        private RelatedDeployments relatedDeployments;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentInfo model) {
            applicationName(model.applicationName);
            deploymentGroupName(model.deploymentGroupName);
            deploymentConfigName(model.deploymentConfigName);
            deploymentId(model.deploymentId);
            previousRevision(model.previousRevision);
            revision(model.revision);
            status(model.status);
            errorInformation(model.errorInformation);
            createTime(model.createTime);
            startTime(model.startTime);
            completeTime(model.completeTime);
            deploymentOverview(model.deploymentOverview);
            description(model.description);
            creator(model.creator);
            ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            rollbackInfo(model.rollbackInfo);
            deploymentStyle(model.deploymentStyle);
            targetInstances(model.targetInstances);
            instanceTerminationWaitTimeStarted(model.instanceTerminationWaitTimeStarted);
            blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            loadBalancerInfo(model.loadBalancerInfo);
            additionalDeploymentStatusInfo(model.additionalDeploymentStatusInfo);
            fileExistsBehavior(model.fileExistsBehavior);
            deploymentStatusMessages(model.deploymentStatusMessages);
            computePlatform(model.computePlatform);
            externalId(model.externalId);
            relatedDeployments(model.relatedDeployments);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final RevisionLocation.Builder getPreviousRevision() {
            return previousRevision != null ? previousRevision.toBuilder() : null;
        }

        public final void setPreviousRevision(RevisionLocation.BuilderImpl previousRevision) {
            this.previousRevision = previousRevision != null ? previousRevision.build() : null;
        }

        @Override
        public final Builder previousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorInformation.Builder getErrorInformation() {
            return errorInformation != null ? errorInformation.toBuilder() : null;
        }

        public final void setErrorInformation(ErrorInformation.BuilderImpl errorInformation) {
            this.errorInformation = errorInformation != null ? errorInformation.build() : null;
        }

        @Override
        public final Builder errorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompleteTime() {
            return completeTime;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final DeploymentOverview.Builder getDeploymentOverview() {
            return deploymentOverview != null ? deploymentOverview.toBuilder() : null;
        }

        public final void setDeploymentOverview(DeploymentOverview.BuilderImpl deploymentOverview) {
            this.deploymentOverview = deploymentOverview != null ? deploymentOverview.build() : null;
        }

        @Override
        public final Builder deploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreator() {
            return creator;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public final Builder creator(DeploymentCreator creator) {
            this.creator(creator == null ? null : creator.toString());
            return this;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return ignoreApplicationStopFailures;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return updateOutdatedInstancesOnly;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final RollbackInfo.Builder getRollbackInfo() {
            return rollbackInfo != null ? rollbackInfo.toBuilder() : null;
        }

        public final void setRollbackInfo(RollbackInfo.BuilderImpl rollbackInfo) {
            this.rollbackInfo = rollbackInfo != null ? rollbackInfo.build() : null;
        }

        @Override
        public final Builder rollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
            return this;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return deploymentStyle != null ? deploymentStyle.toBuilder() : null;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return targetInstances != null ? targetInstances.toBuilder() : null;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final Boolean getInstanceTerminationWaitTimeStarted() {
            return instanceTerminationWaitTimeStarted;
        }

        public final void setInstanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
        }

        @Override
        public final Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
            return this;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        public final void setBlueGreenDeploymentConfiguration(
                BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return loadBalancerInfo != null ? loadBalancerInfo.toBuilder() : null;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final String getAdditionalDeploymentStatusInfo() {
            return additionalDeploymentStatusInfo;
        }

        public final void setAdditionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
        }

        @Override
        public final Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
            return this;
        }

        public final String getFileExistsBehavior() {
            return fileExistsBehavior;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior == null ? null : fileExistsBehavior.toString());
            return this;
        }

        public final Collection<String> getDeploymentStatusMessages() {
            if (deploymentStatusMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return deploymentStatusMessages;
        }

        public final void setDeploymentStatusMessages(Collection<String> deploymentStatusMessages) {
            this.deploymentStatusMessages = DeploymentStatusMessageListCopier.copy(deploymentStatusMessages);
        }

        @Override
        public final Builder deploymentStatusMessages(Collection<String> deploymentStatusMessages) {
            this.deploymentStatusMessages = DeploymentStatusMessageListCopier.copy(deploymentStatusMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentStatusMessages(String... deploymentStatusMessages) {
            deploymentStatusMessages(Arrays.asList(deploymentStatusMessages));
            return this;
        }

        public final String getComputePlatform() {
            return computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final RelatedDeployments.Builder getRelatedDeployments() {
            return relatedDeployments != null ? relatedDeployments.toBuilder() : null;
        }

        public final void setRelatedDeployments(RelatedDeployments.BuilderImpl relatedDeployments) {
            this.relatedDeployments = relatedDeployments != null ? relatedDeployments.build() : null;
        }

        @Override
        public final Builder relatedDeployments(RelatedDeployments relatedDeployments) {
            this.relatedDeployments = relatedDeployments;
            return this;
        }

        @Override
        public DeploymentInfo build() {
            return new DeploymentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
