/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTermsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListTermsResponse> {
    private static final SdkField<List<TermsDescriptionType>> TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Terms").getter(ListTermsResponse.getter(ListTermsResponse::terms)).setter(ListTermsResponse.setter(Builder::terms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Terms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TermsDescriptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTermsResponse.getter(ListTermsResponse::nextToken)).setter(ListTermsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTermsResponse.memberNameToFieldInitializer();
    private final List<TermsDescriptionType> terms;
    private final String nextToken;

    private ListTermsResponse(BuilderImpl builder) {
        super(builder);
        this.terms = builder.terms;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTerms() {
        return this.terms != null && !(this.terms instanceof SdkAutoConstructList);
    }

    public final List<TermsDescriptionType> terms() {
        return this.terms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerms() ? this.terms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTermsResponse)) {
            return false;
        }
        ListTermsResponse other = (ListTermsResponse)((Object)obj);
        return this.hasTerms() == other.hasTerms() && Objects.equals(this.terms(), other.terms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTermsResponse").add("Terms", this.hasTerms() ? this.terms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Terms": {
                return Optional.ofNullable(clazz.cast(this.terms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Terms", TERMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTermsResponse, T> g) {
        return obj -> g.apply((ListTermsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<TermsDescriptionType> terms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTermsResponse model) {
            super(model);
            this.terms(model.terms);
            this.nextToken(model.nextToken);
        }

        public final List<TermsDescriptionType.Builder> getTerms() {
            List<TermsDescriptionType.Builder> result = TermsDescriptionListTypeCopier.copyToBuilder(this.terms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerms(Collection<TermsDescriptionType.BuilderImpl> terms) {
            this.terms = TermsDescriptionListTypeCopier.copyFromBuilder(terms);
        }

        @Override
        public final Builder terms(Collection<TermsDescriptionType> terms) {
            this.terms = TermsDescriptionListTypeCopier.copy(terms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(TermsDescriptionType ... terms) {
            this.terms(Arrays.asList(terms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(Consumer<TermsDescriptionType.Builder> ... terms) {
            this.terms(Stream.of(terms).map(c -> (TermsDescriptionType)((TermsDescriptionType.Builder)TermsDescriptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTermsResponse build() {
            return new ListTermsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTermsResponse> {
        public Builder terms(Collection<TermsDescriptionType> var1);

        public Builder terms(TermsDescriptionType ... var1);

        public Builder terms(Consumer<TermsDescriptionType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

