/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaignsv2.model.LocalTimeZoneDetectionCopier;
import software.amazon.awssdk.services.connectcampaignsv2.model.LocalTimeZoneDetectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalTimeZoneConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalTimeZoneConfig> {
    private static final SdkField<String> DEFAULT_TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultTimeZone").getter(LocalTimeZoneConfig.getter(LocalTimeZoneConfig::defaultTimeZone)).setter(LocalTimeZoneConfig.setter(Builder::defaultTimeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeZone").build()}).build();
    private static final SdkField<List<String>> LOCAL_TIME_ZONE_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("localTimeZoneDetection").getter(LocalTimeZoneConfig.getter(LocalTimeZoneConfig::localTimeZoneDetectionAsStrings)).setter(LocalTimeZoneConfig.setter(Builder::localTimeZoneDetectionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localTimeZoneDetection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_TIME_ZONE_FIELD, LOCAL_TIME_ZONE_DETECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LocalTimeZoneConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultTimeZone;
    private final List<String> localTimeZoneDetection;

    private LocalTimeZoneConfig(BuilderImpl builder) {
        this.defaultTimeZone = builder.defaultTimeZone;
        this.localTimeZoneDetection = builder.localTimeZoneDetection;
    }

    public final String defaultTimeZone() {
        return this.defaultTimeZone;
    }

    public final List<LocalTimeZoneDetectionType> localTimeZoneDetection() {
        return LocalTimeZoneDetectionCopier.copyStringToEnum(this.localTimeZoneDetection);
    }

    public final boolean hasLocalTimeZoneDetection() {
        return this.localTimeZoneDetection != null && !(this.localTimeZoneDetection instanceof SdkAutoConstructList);
    }

    public final List<String> localTimeZoneDetectionAsStrings() {
        return this.localTimeZoneDetection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTimeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalTimeZoneDetection() ? this.localTimeZoneDetectionAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalTimeZoneConfig)) {
            return false;
        }
        LocalTimeZoneConfig other = (LocalTimeZoneConfig)obj;
        return Objects.equals(this.defaultTimeZone(), other.defaultTimeZone()) && this.hasLocalTimeZoneDetection() == other.hasLocalTimeZoneDetection() && Objects.equals(this.localTimeZoneDetectionAsStrings(), other.localTimeZoneDetectionAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LocalTimeZoneConfig").add("DefaultTimeZone", (Object)this.defaultTimeZone()).add("LocalTimeZoneDetection", this.hasLocalTimeZoneDetection() ? this.localTimeZoneDetectionAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultTimeZone": {
                return Optional.ofNullable(clazz.cast(this.defaultTimeZone()));
            }
            case "localTimeZoneDetection": {
                return Optional.ofNullable(clazz.cast(this.localTimeZoneDetectionAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultTimeZone", DEFAULT_TIME_ZONE_FIELD);
        map.put("localTimeZoneDetection", LOCAL_TIME_ZONE_DETECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocalTimeZoneConfig, T> g) {
        return obj -> g.apply((LocalTimeZoneConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultTimeZone;
        private List<String> localTimeZoneDetection = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalTimeZoneConfig model) {
            this.defaultTimeZone(model.defaultTimeZone);
            this.localTimeZoneDetectionWithStrings(model.localTimeZoneDetection);
        }

        public final String getDefaultTimeZone() {
            return this.defaultTimeZone;
        }

        public final void setDefaultTimeZone(String defaultTimeZone) {
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public final Builder defaultTimeZone(String defaultTimeZone) {
            this.defaultTimeZone = defaultTimeZone;
            return this;
        }

        public final Collection<String> getLocalTimeZoneDetection() {
            if (this.localTimeZoneDetection instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localTimeZoneDetection;
        }

        public final void setLocalTimeZoneDetection(Collection<String> localTimeZoneDetection) {
            this.localTimeZoneDetection = LocalTimeZoneDetectionCopier.copy(localTimeZoneDetection);
        }

        @Override
        public final Builder localTimeZoneDetectionWithStrings(Collection<String> localTimeZoneDetection) {
            this.localTimeZoneDetection = LocalTimeZoneDetectionCopier.copy(localTimeZoneDetection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localTimeZoneDetectionWithStrings(String ... localTimeZoneDetection) {
            this.localTimeZoneDetectionWithStrings(Arrays.asList(localTimeZoneDetection));
            return this;
        }

        @Override
        public final Builder localTimeZoneDetection(Collection<LocalTimeZoneDetectionType> localTimeZoneDetection) {
            this.localTimeZoneDetection = LocalTimeZoneDetectionCopier.copyEnumToString(localTimeZoneDetection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localTimeZoneDetection(LocalTimeZoneDetectionType ... localTimeZoneDetection) {
            this.localTimeZoneDetection(Arrays.asList(localTimeZoneDetection));
            return this;
        }

        public LocalTimeZoneConfig build() {
            return new LocalTimeZoneConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalTimeZoneConfig> {
        public Builder defaultTimeZone(String var1);

        public Builder localTimeZoneDetectionWithStrings(Collection<String> var1);

        public Builder localTimeZoneDetectionWithStrings(String ... var1);

        public Builder localTimeZoneDetection(Collection<LocalTimeZoneDetectionType> var1);

        public Builder localTimeZoneDetection(LocalTimeZoneDetectionType ... var1);
    }
}

