/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.signing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.Credentials;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;

public class AwsSigningConfig
extends CrtResource {
    private int algorithm = AwsSigningAlgorithm.SIGV4.getNativeValue();
    private int signatureType = AwsSignatureType.HTTP_REQUEST_VIA_HEADERS.getNativeValue();
    private String region;
    private String service;
    private long time = System.currentTimeMillis();
    private CredentialsProvider credentialsProvider;
    private Credentials credentials;
    private Predicate<String> shouldSignHeader;
    private boolean useDoubleUriEncode = true;
    private boolean shouldNormalizeUriPath = true;
    private boolean omitSessionToken = false;
    private String signedBodyValue = null;
    private int signedBodyHeader = AwsSignedBodyHeaderType.NONE.getNativeValue();
    private long expirationInSeconds = 0L;

    public AwsSigningConfig clone() {
        try (AwsSigningConfig clone = new AwsSigningConfig();){
            clone.setAlgorithm(this.getAlgorithm());
            clone.setSignatureType(this.getSignatureType());
            clone.setRegion(this.getRegion());
            clone.setService(this.getService());
            clone.setTime(this.getTime());
            clone.setCredentialsProvider(this.getCredentialsProvider());
            clone.setCredentials(this.getCredentials());
            clone.setShouldSignHeader(this.getShouldSignHeader());
            clone.setUseDoubleUriEncode(this.getUseDoubleUriEncode());
            clone.setShouldNormalizeUriPath(this.getShouldNormalizeUriPath());
            clone.setOmitSessionToken(this.getOmitSessionToken());
            clone.setSignedBodyValue(this.getSignedBodyValue());
            clone.setSignedBodyHeader(this.getSignedBodyHeader());
            clone.setExpirationInSeconds(this.getExpirationInSeconds());
            clone.addRef();
            AwsSigningConfig awsSigningConfig = clone;
            return awsSigningConfig;
        }
    }

    @Override
    protected void releaseNativeHandle() {
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    public void setAlgorithm(AwsSigningAlgorithm algorithm) {
        this.algorithm = algorithm.getNativeValue();
    }

    public AwsSigningAlgorithm getAlgorithm() {
        return AwsSigningAlgorithm.getEnumValueFromInteger(this.algorithm);
    }

    public void setSignatureType(AwsSignatureType signatureType) {
        this.signatureType = signatureType.getNativeValue();
    }

    public AwsSignatureType getSignatureType() {
        return AwsSignatureType.getEnumValueFromInteger(this.signatureType);
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.swapReferenceTo(this.credentialsProvider, credentialsProvider);
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setShouldSignHeader(Predicate<String> shouldSignHeader) {
        this.shouldSignHeader = shouldSignHeader;
    }

    public Predicate<String> getShouldSignHeader() {
        return this.shouldSignHeader;
    }

    public void setUseDoubleUriEncode(boolean useDoubleUriEncode) {
        this.useDoubleUriEncode = useDoubleUriEncode;
    }

    public boolean getUseDoubleUriEncode() {
        return this.useDoubleUriEncode;
    }

    public void setShouldNormalizeUriPath(boolean shouldNormalizeUriPath) {
        this.shouldNormalizeUriPath = shouldNormalizeUriPath;
    }

    public boolean getShouldNormalizeUriPath() {
        return this.shouldNormalizeUriPath;
    }

    public void setOmitSessionToken(boolean omitSessionToken) {
        this.omitSessionToken = omitSessionToken;
    }

    public boolean getOmitSessionToken() {
        return this.omitSessionToken;
    }

    public void setSignedBodyValue(String signedBodyValue) {
        if (signedBodyValue != null && signedBodyValue.isEmpty()) {
            throw new IllegalArgumentException("Signed Body Value must be null or non-empty string.");
        }
        this.signedBodyValue = signedBodyValue;
    }

    public String getSignedBodyValue() {
        return this.signedBodyValue;
    }

    public void setSignedBodyHeader(AwsSignedBodyHeaderType signedBodyHeader) {
        this.signedBodyHeader = signedBodyHeader.getNativeValue();
    }

    public AwsSignedBodyHeaderType getSignedBodyHeader() {
        return AwsSignedBodyHeaderType.getEnumValueFromInteger(this.signedBodyHeader);
    }

    public void setExpirationInSeconds(long expirationInSeconds) {
        this.expirationInSeconds = expirationInSeconds;
    }

    public long getExpirationInSeconds() {
        return this.expirationInSeconds;
    }

    public static AwsSigningConfig getDefaultS3SigningConfig(String region, CredentialsProvider credentialsProvider) {
        AwsSigningConfig defaultConfig = new AwsSigningConfig();
        defaultConfig.setAlgorithm(AwsSigningAlgorithm.SIGV4);
        defaultConfig.setService("s3");
        defaultConfig.setSignedBodyHeader(AwsSignedBodyHeaderType.X_AMZ_CONTENT_SHA256);
        defaultConfig.setSignedBodyValue("UNSIGNED-PAYLOAD");
        defaultConfig.setRegion(region);
        defaultConfig.setCredentialsProvider(credentialsProvider);
        defaultConfig.setShouldNormalizeUriPath(false);
        defaultConfig.setUseDoubleUriEncode(false);
        return defaultConfig;
    }

    public static enum AwsSigningAlgorithm {
        SIGV4(0),
        SIGV4_ASYMMETRIC(1),
        SIGV4_S3EXPRESS(2);

        private int nativeValue;
        private static Map<Integer, AwsSigningAlgorithm> enumMapping;

        private AwsSigningAlgorithm(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsSigningAlgorithm getEnumValueFromInteger(int value) {
            AwsSigningAlgorithm enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal signing algorithm value in signing configuration");
        }

        private static Map<Integer, AwsSigningAlgorithm> buildEnumMapping() {
            HashMap<Integer, AwsSigningAlgorithm> enumMapping = new HashMap<Integer, AwsSigningAlgorithm>();
            enumMapping.put(SIGV4.getNativeValue(), SIGV4);
            enumMapping.put(SIGV4_ASYMMETRIC.getNativeValue(), SIGV4_ASYMMETRIC);
            enumMapping.put(SIGV4_S3EXPRESS.getNativeValue(), SIGV4_S3EXPRESS);
            return enumMapping;
        }

        static {
            enumMapping = AwsSigningAlgorithm.buildEnumMapping();
        }
    }

    public static enum AwsSignatureType {
        HTTP_REQUEST_VIA_HEADERS(0),
        HTTP_REQUEST_VIA_QUERY_PARAMS(1),
        HTTP_REQUEST_CHUNK(2),
        HTTP_REQUEST_EVENT(3),
        HTTP_REQUEST_TRAILING_HEADERS(6);

        private int nativeValue;
        private static Map<Integer, AwsSignatureType> enumMapping;

        private AwsSignatureType(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsSignatureType getEnumValueFromInteger(int value) {
            AwsSignatureType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal signature type value in signing configuration");
        }

        private static Map<Integer, AwsSignatureType> buildEnumMapping() {
            HashMap<Integer, AwsSignatureType> enumMapping = new HashMap<Integer, AwsSignatureType>();
            enumMapping.put(HTTP_REQUEST_VIA_HEADERS.getNativeValue(), HTTP_REQUEST_VIA_HEADERS);
            enumMapping.put(HTTP_REQUEST_VIA_QUERY_PARAMS.getNativeValue(), HTTP_REQUEST_VIA_QUERY_PARAMS);
            enumMapping.put(HTTP_REQUEST_CHUNK.getNativeValue(), HTTP_REQUEST_CHUNK);
            enumMapping.put(HTTP_REQUEST_EVENT.getNativeValue(), HTTP_REQUEST_EVENT);
            enumMapping.put(HTTP_REQUEST_TRAILING_HEADERS.getNativeValue(), HTTP_REQUEST_TRAILING_HEADERS);
            return enumMapping;
        }

        static {
            enumMapping = AwsSignatureType.buildEnumMapping();
        }
    }

    public static enum AwsSignedBodyHeaderType {
        NONE(0),
        X_AMZ_CONTENT_SHA256(1);

        private int nativeValue;
        private static Map<Integer, AwsSignedBodyHeaderType> enumMapping;

        private AwsSignedBodyHeaderType(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static AwsSignedBodyHeaderType getEnumValueFromInteger(int value) {
            AwsSignedBodyHeaderType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal signed body header value in signing configuration");
        }

        private static Map<Integer, AwsSignedBodyHeaderType> buildEnumMapping() {
            HashMap<Integer, AwsSignedBodyHeaderType> enumMapping = new HashMap<Integer, AwsSignedBodyHeaderType>();
            enumMapping.put(NONE.getNativeValue(), NONE);
            enumMapping.put(X_AMZ_CONTENT_SHA256.getNativeValue(), X_AMZ_CONTENT_SHA256);
            return enumMapping;
        }

        static {
            enumMapping = AwsSignedBodyHeaderType.buildEnumMapping();
        }
    }

    public class AwsSignedBodyValue {
        public static final String EMPTY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
        public static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
        public static final String STREAMING_UNSIGNED_PAYLOAD_TRAILER = "STREAMING-UNSIGNED-PAYLOAD-TRAILER";
        public static final String STREAMING_AWS4_HMAC_SHA256_PAYLOAD = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
        public static final String STREAMING_AWS4_ECDSA_P256_SHA256_PAYLOAD = "STREAMING-AWS4-ECDSA-P256-SHA256-PAYLOAD";
        public static final String STREAMING_AWS4_ECDSA_P256_SHA256_PAYLOAD_TRAILER = "STREAMING-AWS4-ECDSA-P256-SHA256-PAYLOAD-TRAILER";
        public static final String STREAMING_AWS4_HMAC_SHA256_EVENTS = "STREAMING-AWS4-HMAC-SHA256-EVENTS";
    }
}

