/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpVersion;

public class HttpRequestBase {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;
    protected static final int BUFFER_INT_SIZE = 4;
    protected List<HttpHeader> headers;
    protected HttpRequestBodyStream bodyStream;
    protected HttpVersion version = HttpVersion.HTTP_1_1;
    protected String method;
    protected String encodedPath;

    protected HttpRequestBase() {
    }

    protected HttpRequestBase(HttpHeader[] headers, HttpRequestBodyStream bodyStream) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers can be empty, but can't be null");
        }
        this.method = "";
        this.encodedPath = "";
        this.headers = new ArrayList<HttpHeader>(Arrays.asList(headers));
        this.bodyStream = bodyStream;
    }

    public byte[] marshalForJni() {
        int size = 0;
        size += 4;
        size += 4 + this.method.length();
        byte[] pathBytes = this.encodedPath.getBytes(UTF8);
        size += 4 + pathBytes.length;
        for (HttpHeader header : this.headers) {
            if (header.getNameBytes().length <= 0) continue;
            size += header.getNameBytes().length + header.getValueBytes().length + 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(this.version.getValue());
        buffer.putInt(this.method.length());
        buffer.put(this.method.getBytes(UTF8));
        buffer.putInt(pathBytes.length);
        buffer.put(pathBytes);
        for (HttpHeader header : this.headers) {
            if (header.getNameBytes().length <= 0) continue;
            buffer.putInt(header.getNameBytes().length);
            buffer.put(header.getNameBytes());
            buffer.putInt(header.getValueBytes().length);
            buffer.put(header.getValueBytes());
        }
        return buffer.array();
    }

    public HttpRequestBodyStream getBodyStream() {
        return this.bodyStream;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader[] getHeadersAsArray() {
        return this.headers.toArray(new HttpHeader[0]);
    }

    public void addHeader(HttpHeader header) {
        this.headers.add(header);
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.add(new HttpHeader(headerName, headerValue));
    }

    public void addHeaders(HttpHeader[] headers) {
        Collections.addAll(this.headers, headers);
    }
}

