/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>CopyDBClusterSnapshot</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDbClusterSnapshotRequest extends DocDbRequest implements
        ToCopyableBuilder<CopyDbClusterSnapshotRequest.Builder, CopyDbClusterSnapshotRequest> {
    private static final SdkField<String> SOURCE_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterSnapshotRequest::sourceDBClusterSnapshotIdentifier))
            .setter(setter(Builder::sourceDBClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterSnapshotRequest::targetDBClusterSnapshotIdentifier))
            .setter(setter(Builder::targetDBClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyDbClusterSnapshotRequest::preSignedUrl)).setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CopyDbClusterSnapshotRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CopyDbClusterSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, KMS_KEY_ID_FIELD,
            PRE_SIGNED_URL_FIELD, COPY_TAGS_FIELD, TAGS_FIELD));

    private final String sourceDBClusterSnapshotIdentifier;

    private final String targetDBClusterSnapshotIdentifier;

    private final String kmsKeyId;

    private final String preSignedUrl;

    private final Boolean copyTags;

    private final List<Tag> tags;

    private CopyDbClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterSnapshotIdentifier = builder.sourceDBClusterSnapshotIdentifier;
        this.targetDBClusterSnapshotIdentifier = builder.targetDBClusterSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.copyTags = builder.copyTags;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the DB cluster snapshot to copy. This parameter is not case sensitive.
     * </p>
     * <p>
     * You can't copy an encrypted, shared DB cluster snapshot from one AWS Region to another.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must specify a valid system snapshot in the "available" state.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source snapshot is in a different AWS Region than the copy, specify a valid DB cluster snapshot ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster-snapshot1</code>
     * </p>
     * 
     * @return The identifier of the DB cluster snapshot to copy. This parameter is not case sensitive.</p>
     *         <p>
     *         You can't copy an encrypted, shared DB cluster snapshot from one AWS Region to another.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must specify a valid system snapshot in the "available" state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the source snapshot is in a different AWS Region than the copy, specify a valid DB cluster snapshot
     *         ARN.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster-snapshot1</code>
     */
    public String sourceDBClusterSnapshotIdentifier() {
        return sourceDBClusterSnapshotIdentifier;
    }

    /**
     * <p>
     * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is
     * not case sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster-snapshot2</code>
     * </p>
     * 
     * @return The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This
     *         parameter is not case sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster-snapshot2</code>
     */
    public String targetDBClusterSnapshotIdentifier() {
        return targetDBClusterSnapshotIdentifier;
    }

    /**
     * <p>
     * The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key ID is the Amazon Resource Name (ARN),
     * AWS KMS key identifier, or the AWS KMS key alias for the AWS KMS encryption key.
     * </p>
     * <p>
     * If you copy an encrypted DB cluster snapshot from your AWS account, you can specify a value for
     * <code>KmsKeyId</code> to encrypt the copy with a new AWS KMS encryption key. If you don't specify a value for
     * <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same AWS KMS key as the
     * source DB cluster snapshot.
     * </p>
     * <p>
     * If you copy an encrypted DB cluster snapshot that is shared from another AWS account, then you must specify a
     * value for <code>KmsKeyId</code>.
     * </p>
     * <p>
     * To copy an encrypted DB cluster snapshot to another AWS Region, set <code>KmsKeyId</code> to the AWS KMS key ID
     * that you want to use to encrypt the copy of the DB cluster snapshot in the destination Region. AWS KMS encryption
     * keys are specific to the AWS Region that they are created in, and you can't use encryption keys from one Region
     * in another Region.
     * </p>
     * <p>
     * If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an
     * error is returned.
     * </p>
     * 
     * @return The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key ID is the Amazon Resource Name
     *         (ARN), AWS KMS key identifier, or the AWS KMS key alias for the AWS KMS encryption key. </p>
     *         <p>
     *         If you copy an encrypted DB cluster snapshot from your AWS account, you can specify a value for
     *         <code>KmsKeyId</code> to encrypt the copy with a new AWS KMS encryption key. If you don't specify a value
     *         for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same AWS KMS
     *         key as the source DB cluster snapshot.
     *         </p>
     *         <p>
     *         If you copy an encrypted DB cluster snapshot that is shared from another AWS account, then you must
     *         specify a value for <code>KmsKeyId</code>.
     *         </p>
     *         <p>
     *         To copy an encrypted DB cluster snapshot to another AWS Region, set <code>KmsKeyId</code> to the AWS KMS
     *         key ID that you want to use to encrypt the copy of the DB cluster snapshot in the destination Region. AWS
     *         KMS encryption keys are specific to the AWS Region that they are created in, and you can't use encryption
     *         keys from one Region in another Region.
     *         </p>
     *         <p>
     *         If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code>
     *         parameter, an error is returned.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action
     * in the AWS Region that contains the source DB cluster snapshot to copy. You must use the
     * <code>PreSignedUrl</code> parameter when copying an encrypted DB cluster snapshot from another AWS Region.
     * </p>
     * <p>
     * The presigned URL must be a valid request for the <code>CopyDBSClusterSnapshot</code> API action that can be
     * executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied. The presigned URL
     * request must contain the following parameter values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The AWS KMS key identifier for the key to use to encrypt the copy of the DB cluster
     * snapshot in the destination AWS Region. This is the same identifier for both the
     * <code>CopyDBClusterSnapshot</code> action that is called in the destination AWS Region, and the action contained
     * in the presigned URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source AWS
     * Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS Region, then your
     * <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example:
     * <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API
     *         action in the AWS Region that contains the source DB cluster snapshot to copy. You must use the
     *         <code>PreSignedUrl</code> parameter when copying an encrypted DB cluster snapshot from another AWS
     *         Region.</p>
     *         <p>
     *         The presigned URL must be a valid request for the <code>CopyDBSClusterSnapshot</code> API action that can
     *         be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied. The
     *         presigned URL request must contain the following parameter values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsKeyId</code> - The AWS KMS key identifier for the key to use to encrypt the copy of the DB
     *         cluster snapshot in the destination AWS Region. This is the same identifier for both the
     *         <code>CopyDBClusterSnapshot</code> action that is called in the destination AWS Region, and the action
     *         contained in the presigned URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be created
     *         in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB
     *         cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the
     *         source AWS Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2
     *         AWS Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example:
     *         <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115</code>.
     *         </p>
     *         </li>
     */
    public String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * <p>
     * Set to <code>true</code> to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot,
     * and otherwise <code>false</code>. The default is <code>false</code>.
     * </p>
     * 
     * @return Set to <code>true</code> to copy all tags from the source DB cluster snapshot to the target DB cluster
     *         snapshot, and otherwise <code>false</code>. The default is <code>false</code>.
     */
    public Boolean copyTags() {
        return copyTags;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the DB cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be assigned to the DB cluster snapshot.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterSnapshotRequest)) {
            return false;
        }
        CopyDbClusterSnapshotRequest other = (CopyDbClusterSnapshotRequest) obj;
        return Objects.equals(sourceDBClusterSnapshotIdentifier(), other.sourceDBClusterSnapshotIdentifier())
                && Objects.equals(targetDBClusterSnapshotIdentifier(), other.targetDBClusterSnapshotIdentifier())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(copyTags(), other.copyTags()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyDbClusterSnapshotRequest")
                .add("SourceDBClusterSnapshotIdentifier", sourceDBClusterSnapshotIdentifier())
                .add("TargetDBClusterSnapshotIdentifier", targetDBClusterSnapshotIdentifier()).add("KmsKeyId", kmsKeyId())
                .add("PreSignedUrl", preSignedUrl()).add("CopyTags", copyTags()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDBClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterSnapshotIdentifier()));
        case "TargetDBClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(targetDBClusterSnapshotIdentifier()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyDbClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyDbClusterSnapshotRequest> {
        /**
         * <p>
         * The identifier of the DB cluster snapshot to copy. This parameter is not case sensitive.
         * </p>
         * <p>
         * You can't copy an encrypted, shared DB cluster snapshot from one AWS Region to another.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must specify a valid system snapshot in the "available" state.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the source snapshot is in a different AWS Region than the copy, specify a valid DB cluster snapshot ARN.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster-snapshot1</code>
         * </p>
         * 
         * @param sourceDBClusterSnapshotIdentifier
         *        The identifier of the DB cluster snapshot to copy. This parameter is not case sensitive.</p>
         *        <p>
         *        You can't copy an encrypted, shared DB cluster snapshot from one AWS Region to another.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must specify a valid system snapshot in the "available" state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source snapshot is in the same AWS Region as the copy, specify a valid DB snapshot identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the source snapshot is in a different AWS Region than the copy, specify a valid DB cluster snapshot
         *        ARN.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster-snapshot1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier);

        /**
         * <p>
         * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter
         * is not case sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster-snapshot2</code>
         * </p>
         * 
         * @param targetDBClusterSnapshotIdentifier
         *        The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This
         *        parameter is not case sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster-snapshot2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier);

        /**
         * <p>
         * The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key ID is the Amazon Resource Name
         * (ARN), AWS KMS key identifier, or the AWS KMS key alias for the AWS KMS encryption key.
         * </p>
         * <p>
         * If you copy an encrypted DB cluster snapshot from your AWS account, you can specify a value for
         * <code>KmsKeyId</code> to encrypt the copy with a new AWS KMS encryption key. If you don't specify a value for
         * <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same AWS KMS key as the
         * source DB cluster snapshot.
         * </p>
         * <p>
         * If you copy an encrypted DB cluster snapshot that is shared from another AWS account, then you must specify a
         * value for <code>KmsKeyId</code>.
         * </p>
         * <p>
         * To copy an encrypted DB cluster snapshot to another AWS Region, set <code>KmsKeyId</code> to the AWS KMS key
         * ID that you want to use to encrypt the copy of the DB cluster snapshot in the destination Region. AWS KMS
         * encryption keys are specific to the AWS Region that they are created in, and you can't use encryption keys
         * from one Region in another Region.
         * </p>
         * <p>
         * If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter,
         * an error is returned.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key ID is the Amazon Resource
         *        Name (ARN), AWS KMS key identifier, or the AWS KMS key alias for the AWS KMS encryption key. </p>
         *        <p>
         *        If you copy an encrypted DB cluster snapshot from your AWS account, you can specify a value for
         *        <code>KmsKeyId</code> to encrypt the copy with a new AWS KMS encryption key. If you don't specify a
         *        value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same
         *        AWS KMS key as the source DB cluster snapshot.
         *        </p>
         *        <p>
         *        If you copy an encrypted DB cluster snapshot that is shared from another AWS account, then you must
         *        specify a value for <code>KmsKeyId</code>.
         *        </p>
         *        <p>
         *        To copy an encrypted DB cluster snapshot to another AWS Region, set <code>KmsKeyId</code> to the AWS
         *        KMS key ID that you want to use to encrypt the copy of the DB cluster snapshot in the destination
         *        Region. AWS KMS encryption keys are specific to the AWS Region that they are created in, and you can't
         *        use encryption keys from one Region in another Region.
         *        </p>
         *        <p>
         *        If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code>
         *        parameter, an error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API
         * action in the AWS Region that contains the source DB cluster snapshot to copy. You must use the
         * <code>PreSignedUrl</code> parameter when copying an encrypted DB cluster snapshot from another AWS Region.
         * </p>
         * <p>
         * The presigned URL must be a valid request for the <code>CopyDBSClusterSnapshot</code> API action that can be
         * executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied. The presigned
         * URL request must contain the following parameter values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsKeyId</code> - The AWS KMS key identifier for the key to use to encrypt the copy of the DB cluster
         * snapshot in the destination AWS Region. This is the same identifier for both the
         * <code>CopyDBClusterSnapshot</code> action that is called in the destination AWS Region, and the action
         * contained in the presigned URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be created in.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB
         * cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the
         * source AWS Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 AWS
         * Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example:
         * <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preSignedUrl
         *        The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code>
         *        API action in the AWS Region that contains the source DB cluster snapshot to copy. You must use the
         *        <code>PreSignedUrl</code> parameter when copying an encrypted DB cluster snapshot from another AWS
         *        Region.</p>
         *        <p>
         *        The presigned URL must be a valid request for the <code>CopyDBSClusterSnapshot</code> API action that
         *        can be executed in the source AWS Region that contains the encrypted DB cluster snapshot to be copied.
         *        The presigned URL request must contain the following parameter values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsKeyId</code> - The AWS KMS key identifier for the key to use to encrypt the copy of the DB
         *        cluster snapshot in the destination AWS Region. This is the same identifier for both the
         *        <code>CopyDBClusterSnapshot</code> action that is called in the destination AWS Region, and the action
         *        contained in the presigned URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DestinationRegion</code> - The name of the AWS Region that the DB cluster snapshot will be
         *        created in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted
         *        DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for
         *        the source AWS Region. For example, if you are copying an encrypted DB cluster snapshot from the
         *        us-west-2 AWS Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the
         *        following example:
         *        <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * <p>
         * Set to <code>true</code> to copy all tags from the source DB cluster snapshot to the target DB cluster
         * snapshot, and otherwise <code>false</code>. The default is <code>false</code>.
         * </p>
         * 
         * @param copyTags
         *        Set to <code>true</code> to copy all tags from the source DB cluster snapshot to the target DB cluster
         *        snapshot, and otherwise <code>false</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The tags to be assigned to the DB cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the DB cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the DB cluster snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String sourceDBClusterSnapshotIdentifier;

        private String targetDBClusterSnapshotIdentifier;

        private String kmsKeyId;

        private String preSignedUrl;

        private Boolean copyTags;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterSnapshotRequest model) {
            super(model);
            sourceDBClusterSnapshotIdentifier(model.sourceDBClusterSnapshotIdentifier);
            targetDBClusterSnapshotIdentifier(model.targetDBClusterSnapshotIdentifier);
            kmsKeyId(model.kmsKeyId);
            preSignedUrl(model.preSignedUrl);
            copyTags(model.copyTags);
            tags(model.tags);
        }

        public final String getSourceDBClusterSnapshotIdentifier() {
            return sourceDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
        }

        public final String getTargetDBClusterSnapshotIdentifier() {
            return targetDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbClusterSnapshotRequest build() {
            return new CopyDbClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
