/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of <a>DBClusterParameterGroups</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbClusterParameterGroupsResponse extends DocDbResponse implements
        ToCopyableBuilder<DescribeDbClusterParameterGroupsResponse.Builder, DescribeDbClusterParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDbClusterParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBClusterParameterGroup>> DB_CLUSTER_PARAMETER_GROUPS_FIELD = SdkField
            .<List<DBClusterParameterGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDbClusterParameterGroupsResponse::dbClusterParameterGroups))
            .setter(setter(Builder::dbClusterParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBClusterParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<DBClusterParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBClusterParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBClusterParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_CLUSTER_PARAMETER_GROUPS_FIELD));

    private final String marker;

    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDbClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the DBClusterParameterGroups property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDbClusterParameterGroups() {
        return dbClusterParameterGroups != null && !(dbClusterParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DB cluster parameter groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbClusterParameterGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DB cluster parameter groups.
     */
    public List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return dbClusterParameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDbClusterParameterGroupsResponse other = (DescribeDbClusterParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker())
                && Objects.equals(dbClusterParameterGroups(), other.dbClusterParameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDbClusterParameterGroupsResponse").add("Marker", marker())
                .add("DBClusterParameterGroups", dbClusterParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBClusterParameterGroups":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * 
         * @param dbClusterParameterGroups
         *        A list of DB cluster parameter groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * 
         * @param dbClusterParameterGroups
         *        A list of DB cluster parameter groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroups(DBClusterParameterGroup... dbClusterParameterGroups);

        /**
         * <p>
         * A list of DB cluster parameter groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBClusterParameterGroup>.Builder} avoiding
         * the need to create one manually via {@link List<DBClusterParameterGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBClusterParameterGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #dbClusterParameterGroups(List<DBClusterParameterGroup>)}.
         * 
         * @param dbClusterParameterGroups
         *        a consumer that will call methods on {@link List<DBClusterParameterGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterParameterGroups(List<DBClusterParameterGroup>)
         */
        Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder>... dbClusterParameterGroups);
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBClusterParameterGroup> dbClusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterParameterGroup.Builder> getDbClusterParameterGroups() {
            return dbClusterParameterGroups != null ? dbClusterParameterGroups.stream().map(DBClusterParameterGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup... dbClusterParameterGroups) {
            dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder>... dbClusterParameterGroups) {
            dbClusterParameterGroups(Stream.of(dbClusterParameterGroups)
                    .map(c -> DBClusterParameterGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterParameterGroups(Collection<DBClusterParameterGroup.BuilderImpl> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copyFromBuilder(dbClusterParameterGroups);
        }

        @Override
        public DescribeDbClusterParameterGroupsResponse build() {
            return new DescribeDbClusterParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
