/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.internal.UserAgentUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanPublisher
implements SdkPublisher<ScanResponse> {
    private final DynamoDbAsyncClient client;
    private final ScanRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ScanPublisher(DynamoDbAsyncClient client, ScanRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ScanPublisher(DynamoDbAsyncClient client, ScanRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ScanResponseFetcher();
    }

    public void subscribe(Subscriber<? super ScanResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map<String, AttributeValue>> items() {
        return this.flatMapIterable(response -> response.items());
    }

    private class ScanResponseFetcher
    implements AsyncPageFetcher<ScanResponse> {
        private ScanResponseFetcher() {
        }

        public boolean hasNextPage(ScanResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.lastEvaluatedKey());
        }

        public CompletableFuture<ScanResponse> nextPage(ScanResponse previousPage) {
            if (previousPage == null) {
                return ScanPublisher.this.client.scan(ScanPublisher.this.firstRequest);
            }
            return ScanPublisher.this.client.scan((ScanRequest)((Object)ScanPublisher.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

