/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import software.amazon.awssdk.services.dynamodb.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultDynamoDbWaiter
implements DynamoDbWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final DynamoDbClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeContributorInsightsResponse> contributorInsightsEnabledWaiter;
    private final Waiter<DescribeExportResponse> exportCompletedWaiter;
    private final Waiter<DescribeImportResponse> importCompletedWaiter;
    private final Waiter<DescribeKinesisStreamingDestinationResponse> kinesisStreamingDestinationActiveWaiter;
    private final Waiter<DescribeTableResponse> tableExistsWaiter;
    private final Waiter<DescribeTableResponse> tableNotExistsWaiter;

    private DefaultDynamoDbWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DynamoDbClient)DynamoDbClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.contributorInsightsEnabledWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeContributorInsightsResponse.class).acceptors(DefaultDynamoDbWaiter.contributorInsightsEnabledWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.contributorInsightsEnabledWaiterConfig(builder.overrideConfiguration))).build();
        this.exportCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeExportResponse.class).acceptors(DefaultDynamoDbWaiter.exportCompletedWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.exportCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.importCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImportResponse.class).acceptors(DefaultDynamoDbWaiter.importCompletedWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.importCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.kinesisStreamingDestinationActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeKinesisStreamingDestinationResponse.class).acceptors(DefaultDynamoDbWaiter.kinesisStreamingDestinationActiveWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.kinesisStreamingDestinationActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.tableExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTableResponse.class).acceptors(DefaultDynamoDbWaiter.tableExistsWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.tableExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.tableNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTableResponse.class).acceptors(DefaultDynamoDbWaiter.tableNotExistsWaiterAcceptors())).overrideConfiguration(DefaultDynamoDbWaiter.tableNotExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeContributorInsightsResponse> waitUntilContributorInsightsEnabled(DescribeContributorInsightsRequest describeContributorInsightsRequest) {
        return this.contributorInsightsEnabledWaiter.run(() -> this.client.describeContributorInsights(this.applyWaitersUserAgent(describeContributorInsightsRequest)));
    }

    @Override
    public WaiterResponse<DescribeContributorInsightsResponse> waitUntilContributorInsightsEnabled(DescribeContributorInsightsRequest describeContributorInsightsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.contributorInsightsEnabledWaiter.run(() -> this.client.describeContributorInsights(this.applyWaitersUserAgent(describeContributorInsightsRequest)), DefaultDynamoDbWaiter.contributorInsightsEnabledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportResponse> waitUntilExportCompleted(DescribeExportRequest describeExportRequest) {
        return this.exportCompletedWaiter.run(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportResponse> waitUntilExportCompleted(DescribeExportRequest describeExportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.exportCompletedWaiter.run(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)), DefaultDynamoDbWaiter.exportCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImportResponse> waitUntilImportCompleted(DescribeImportRequest describeImportRequest) {
        return this.importCompletedWaiter.run(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)));
    }

    @Override
    public WaiterResponse<DescribeImportResponse> waitUntilImportCompleted(DescribeImportRequest describeImportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.importCompletedWaiter.run(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)), DefaultDynamoDbWaiter.importCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeKinesisStreamingDestinationResponse> waitUntilKinesisStreamingDestinationActive(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) {
        return this.kinesisStreamingDestinationActiveWaiter.run(() -> this.client.describeKinesisStreamingDestination(this.applyWaitersUserAgent(describeKinesisStreamingDestinationRequest)));
    }

    @Override
    public WaiterResponse<DescribeKinesisStreamingDestinationResponse> waitUntilKinesisStreamingDestinationActive(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.kinesisStreamingDestinationActiveWaiter.run(() -> this.client.describeKinesisStreamingDestination(this.applyWaitersUserAgent(describeKinesisStreamingDestinationRequest)), DefaultDynamoDbWaiter.kinesisStreamingDestinationActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTableResponse> waitUntilTableExists(DescribeTableRequest describeTableRequest) {
        return this.tableExistsWaiter.run(() -> this.client.describeTable(this.applyWaitersUserAgent(describeTableRequest)));
    }

    @Override
    public WaiterResponse<DescribeTableResponse> waitUntilTableExists(DescribeTableRequest describeTableRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tableExistsWaiter.run(() -> this.client.describeTable(this.applyWaitersUserAgent(describeTableRequest)), DefaultDynamoDbWaiter.tableExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTableResponse> waitUntilTableNotExists(DescribeTableRequest describeTableRequest) {
        return this.tableNotExistsWaiter.run(() -> this.client.describeTable(this.applyWaitersUserAgent(describeTableRequest)));
    }

    @Override
    public WaiterResponse<DescribeTableResponse> waitUntilTableNotExists(DescribeTableRequest describeTableRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tableNotExistsWaiter.run(() -> this.client.describeTable(this.applyWaitersUserAgent(describeTableRequest)), DefaultDynamoDbWaiter.tableNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeContributorInsightsResponse>> contributorInsightsEnabledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeContributorInsightsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeContributorInsightsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ContributorInsightsStatus").value(), "ENABLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ContributorInsightsStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ContributorInsightsStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportResponse>> exportCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportDescription").field("ExportStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportDescription").field("ExportStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportDescription.ExportStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportResponse>> importCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportTableDescription").field("ImportStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportTableDescription").field("ImportStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ImportTableDescription.ImportStatus=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportTableDescription").field("ImportStatus").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ImportTableDescription.ImportStatus=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeKinesisStreamingDestinationResponse>> kinesisStreamingDestinationActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeKinesisStreamingDestinationResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeKinesisStreamingDestinationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("KinesisDataStreamDestinations").flatten().field("DestinationStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ACTIVE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("KinesisDataStreamDestinations").length().compare(">", input.constant(new BigDecimal("0"))).and(input.field("KinesisDataStreamDestinations").filter(x0 -> x0.field("DestinationStatus").compare("==", x0.constant("DISABLED")).or(x0.field("DestinationStatus").compare("==", x0.constant("ENABLE_FAILED")))).length().compare("==", input.field("KinesisDataStreamDestinations").length())).value(), true);
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (length(KinesisDataStreamDestinations) > `0`  && length(KinesisDataStreamDestinations[?DestinationStatus == 'DISABLED' || DestinationStatus == 'ENABLE_FAILED']) ==  length(KinesisDataStreamDestinations)=true) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTableResponse>> tableExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTableResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTableResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Table").field("TableStatus").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultDynamoDbWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTableResponse>> tableNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTableResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTableResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDynamoDbWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration contributorInsightsEnabledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration importCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration kinesisStreamingDestinationActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tableExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(25);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tableNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(25);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DynamoDbWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DynamoDbRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DynamoDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DynamoDbWaiter.Builder {
        private DynamoDbClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public DynamoDbWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DynamoDbWaiter.Builder client(DynamoDbClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DynamoDbWaiter build() {
            return new DefaultDynamoDbWaiter(this);
        }
    }
}

