/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceDetails> {
    private static final SdkField<String> PENDING_MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingMaintenance").getter(MaintenanceDetails.getter(MaintenanceDetails::pendingMaintenance)).setter(MaintenanceDetails.setter(Builder::pendingMaintenance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenance").unmarshallLocationName("pendingMaintenance").build()}).build();
    private static final SdkField<Instant> MAINTENANCE_AUTO_APPLIED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MaintenanceAutoAppliedAfter").getter(MaintenanceDetails.getter(MaintenanceDetails::maintenanceAutoAppliedAfter)).setter(MaintenanceDetails.setter(Builder::maintenanceAutoAppliedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceAutoAppliedAfter").unmarshallLocationName("maintenanceAutoAppliedAfter").build()}).build();
    private static final SdkField<Instant> LAST_MAINTENANCE_APPLIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastMaintenanceApplied").getter(MaintenanceDetails.getter(MaintenanceDetails::lastMaintenanceApplied)).setter(MaintenanceDetails.setter(Builder::lastMaintenanceApplied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMaintenanceApplied").unmarshallLocationName("lastMaintenanceApplied").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_MAINTENANCE_FIELD, MAINTENANCE_AUTO_APPLIED_AFTER_FIELD, LAST_MAINTENANCE_APPLIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaintenanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pendingMaintenance;
    private final Instant maintenanceAutoAppliedAfter;
    private final Instant lastMaintenanceApplied;

    private MaintenanceDetails(BuilderImpl builder) {
        this.pendingMaintenance = builder.pendingMaintenance;
        this.maintenanceAutoAppliedAfter = builder.maintenanceAutoAppliedAfter;
        this.lastMaintenanceApplied = builder.lastMaintenanceApplied;
    }

    public final String pendingMaintenance() {
        return this.pendingMaintenance;
    }

    public final Instant maintenanceAutoAppliedAfter() {
        return this.maintenanceAutoAppliedAfter;
    }

    public final Instant lastMaintenanceApplied() {
        return this.lastMaintenanceApplied;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceAutoAppliedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMaintenanceApplied());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceDetails)) {
            return false;
        }
        MaintenanceDetails other = (MaintenanceDetails)obj;
        return Objects.equals(this.pendingMaintenance(), other.pendingMaintenance()) && Objects.equals(this.maintenanceAutoAppliedAfter(), other.maintenanceAutoAppliedAfter()) && Objects.equals(this.lastMaintenanceApplied(), other.lastMaintenanceApplied());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceDetails").add("PendingMaintenance", (Object)this.pendingMaintenance()).add("MaintenanceAutoAppliedAfter", (Object)this.maintenanceAutoAppliedAfter()).add("LastMaintenanceApplied", (Object)this.lastMaintenanceApplied()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingMaintenance": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenance()));
            }
            case "MaintenanceAutoAppliedAfter": {
                return Optional.ofNullable(clazz.cast(this.maintenanceAutoAppliedAfter()));
            }
            case "LastMaintenanceApplied": {
                return Optional.ofNullable(clazz.cast(this.lastMaintenanceApplied()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PendingMaintenance", PENDING_MAINTENANCE_FIELD);
        map.put("MaintenanceAutoAppliedAfter", MAINTENANCE_AUTO_APPLIED_AFTER_FIELD);
        map.put("LastMaintenanceApplied", LAST_MAINTENANCE_APPLIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceDetails, T> g) {
        return obj -> g.apply((MaintenanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pendingMaintenance;
        private Instant maintenanceAutoAppliedAfter;
        private Instant lastMaintenanceApplied;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceDetails model) {
            this.pendingMaintenance(model.pendingMaintenance);
            this.maintenanceAutoAppliedAfter(model.maintenanceAutoAppliedAfter);
            this.lastMaintenanceApplied(model.lastMaintenanceApplied);
        }

        public final String getPendingMaintenance() {
            return this.pendingMaintenance;
        }

        public final void setPendingMaintenance(String pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
        }

        @Override
        public final Builder pendingMaintenance(String pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
            return this;
        }

        public final Instant getMaintenanceAutoAppliedAfter() {
            return this.maintenanceAutoAppliedAfter;
        }

        public final void setMaintenanceAutoAppliedAfter(Instant maintenanceAutoAppliedAfter) {
            this.maintenanceAutoAppliedAfter = maintenanceAutoAppliedAfter;
        }

        @Override
        public final Builder maintenanceAutoAppliedAfter(Instant maintenanceAutoAppliedAfter) {
            this.maintenanceAutoAppliedAfter = maintenanceAutoAppliedAfter;
            return this;
        }

        public final Instant getLastMaintenanceApplied() {
            return this.lastMaintenanceApplied;
        }

        public final void setLastMaintenanceApplied(Instant lastMaintenanceApplied) {
            this.lastMaintenanceApplied = lastMaintenanceApplied;
        }

        @Override
        public final Builder lastMaintenanceApplied(Instant lastMaintenanceApplied) {
            this.lastMaintenanceApplied = lastMaintenanceApplied;
            return this;
        }

        public MaintenanceDetails build() {
            return new MaintenanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceDetails> {
        public Builder pendingMaintenance(String var1);

        public Builder maintenanceAutoAppliedAfter(Instant var1);

        public Builder lastMaintenanceApplied(Instant var1);
    }
}

