/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.DesiredStatus;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTasksRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListTasksRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(ListTasksRequest.getter(ListTasksRequest::cluster)).setter(ListTasksRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstance").getter(ListTasksRequest.getter(ListTasksRequest::containerInstance)).setter(ListTasksRequest.setter(Builder::containerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()}).build();
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("family").getter(ListTasksRequest.getter(ListTasksRequest::family)).setter(ListTasksRequest.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTasksRequest.getter(ListTasksRequest::nextToken)).setter(ListTasksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTasksRequest.getter(ListTasksRequest::maxResults)).setter(ListTasksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(ListTasksRequest.getter(ListTasksRequest::startedBy)).setter(ListTasksRequest.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ListTasksRequest.getter(ListTasksRequest::serviceName)).setter(ListTasksRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> DESIRED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredStatus").getter(ListTasksRequest.getter(ListTasksRequest::desiredStatusAsString)).setter(ListTasksRequest.setter(Builder::desiredStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredStatus").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(ListTasksRequest.getter(ListTasksRequest::launchTypeAsString)).setter(ListTasksRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, CONTAINER_INSTANCE_FIELD, FAMILY_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTED_BY_FIELD, SERVICE_NAME_FIELD, DESIRED_STATUS_FIELD, LAUNCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTasksRequest.memberNameToFieldInitializer();
    private final String cluster;
    private final String containerInstance;
    private final String family;
    private final String nextToken;
    private final Integer maxResults;
    private final String startedBy;
    private final String serviceName;
    private final String desiredStatus;
    private final String launchType;

    private ListTasksRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstance = builder.containerInstance;
        this.family = builder.family;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startedBy = builder.startedBy;
        this.serviceName = builder.serviceName;
        this.desiredStatus = builder.desiredStatus;
        this.launchType = builder.launchType;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String containerInstance() {
        return this.containerInstance;
    }

    public final String family() {
        return this.family;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final DesiredStatus desiredStatus() {
        return DesiredStatus.fromValue(this.desiredStatus);
    }

    public final String desiredStatusAsString() {
        return this.desiredStatus;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTasksRequest)) {
            return false;
        }
        ListTasksRequest other = (ListTasksRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.containerInstance(), other.containerInstance()) && Objects.equals(this.family(), other.family()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.desiredStatusAsString(), other.desiredStatusAsString()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListTasksRequest").add("Cluster", (Object)this.cluster()).add("ContainerInstance", (Object)this.containerInstance()).add("Family", (Object)this.family()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartedBy", (Object)this.startedBy()).add("ServiceName", (Object)this.serviceName()).add("DesiredStatus", (Object)this.desiredStatusAsString()).add("LaunchType", (Object)this.launchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "containerInstance": {
                return Optional.ofNullable(clazz.cast(this.containerInstance()));
            }
            case "family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "desiredStatus": {
                return Optional.ofNullable(clazz.cast(this.desiredStatusAsString()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("containerInstance", CONTAINER_INSTANCE_FIELD);
        map.put("family", FAMILY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("startedBy", STARTED_BY_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("desiredStatus", DESIRED_STATUS_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTasksRequest, T> g) {
        return obj -> g.apply((ListTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String containerInstance;
        private String family;
        private String nextToken;
        private Integer maxResults;
        private String startedBy;
        private String serviceName;
        private String desiredStatus;
        private String launchType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTasksRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.containerInstance(model.containerInstance);
            this.family(model.family);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startedBy(model.startedBy);
            this.serviceName(model.serviceName);
            this.desiredStatus(model.desiredStatus);
            this.launchType(model.launchType);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getContainerInstance() {
            return this.containerInstance;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        @Override
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final String getFamily() {
            return this.family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getDesiredStatus() {
            return this.desiredStatus;
        }

        public final void setDesiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
        }

        @Override
        public final Builder desiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
            return this;
        }

        @Override
        public final Builder desiredStatus(DesiredStatus desiredStatus) {
            this.desiredStatus(desiredStatus == null ? null : desiredStatus.toString());
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTasksRequest build() {
            return new ListTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTasksRequest> {
        public Builder cluster(String var1);

        public Builder containerInstance(String var1);

        public Builder family(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startedBy(String var1);

        public Builder serviceName(String var1);

        public Builder desiredStatus(String var1);

        public Builder desiredStatus(DesiredStatus var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

