/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the new or existing destination file system for the replication configuration.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If you want to replicate to a new file system, do not specify the File System ID for the destination file system.
 * Amazon EFS creates a new, empty file system. For One Zone storage, specify the Availability Zone to create the file
 * system in. To use an Key Management Service key other than the default KMS key, then specify it. For more
 * information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/create-replication.html">Configuring replication
 * to new Amazon EFS file system</a> in the <i>Amazon EFS User Guide</i>.
 * </p>
 * <note>
 * <p>
 * After the file system is created, you cannot change the KMS key or the performance mode.
 * </p>
 * </note></li>
 * <li>
 * <p>
 * If you want to replicate to an existing file system that's in the same account as the source file system, then you
 * need to provide the ID or Amazon Resource Name (ARN) of the file system to which to replicate. The file system's
 * replication overwrite protection must be disabled. For more information, see <a
 * href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication#replicate-existing-destination">Replicating to an
 * existing file system</a> in the <i>Amazon EFS User Guide</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you are replicating the file system to a file system that's in a different account than the source file system
 * (cross-account replication), you need to provide the ARN for the file system and the IAM role that allows Amazon EFS
 * to perform replication on the destination account. The file system's replication overwrite protection must be
 * disabled. For more information, see <a
 * href="https://docs.aws.amazon.com/efs/latest/ug/cross-account-replication.html">Replicating across Amazon Web
 * Services accounts</a> in the <i>Amazon EFS User Guide</i>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationToCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationToCreate.Builder, DestinationToCreate> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(DestinationToCreate::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneName").getter(getter(DestinationToCreate::availabilityZoneName))
            .setter(setter(Builder::availabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DestinationToCreate::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(DestinationToCreate::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DestinationToCreate::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AVAILABILITY_ZONE_NAME_FIELD, KMS_KEY_ID_FIELD, FILE_SYSTEM_ID_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String availabilityZoneName;

    private final String kmsKeyId;

    private final String fileSystemId;

    private final String roleArn;

    private DestinationToCreate(BuilderImpl builder) {
        this.region = builder.region;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.kmsKeyId = builder.kmsKeyId;
        this.fileSystemId = builder.fileSystemId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create the
     * destination file system. The Region must be enabled for the Amazon Web Services account that owns the source file
     * system. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Managing Amazon Web
     * Services Regions</a> in the <i>Amazon Web Services General Reference Reference Guide</i>.
     * </p>
     * 
     * @return To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to
     *         create the destination file system. The Region must be enabled for the Amazon Web Services account that
     *         owns the source file system. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Managing
     *         Amazon Web Services Regions</a> in the <i>Amazon Web Services General Reference Reference Guide</i>.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to create
     * the destination file system.
     * </p>
     * 
     * @return To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to
     *         create the destination file system.
     */
    public final String availabilityZoneName() {
        return availabilityZoneName;
    }

    /**
     * <p>
     * Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If you
     * do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS,
     * <code>/aws/elasticfilesystem</code>. This ID can be in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID - The unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN - The ARN for the key, for example
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias ARN - The ARN for a key alias, for example
     * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file system.
     *         If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS,
     *         <code>/aws/elasticfilesystem</code>. This ID can be in one of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID - The unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN - The ARN for the key, for example
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias ARN - The ARN for a key alias, for example
     *         <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ID or ARN of the file system to use for the destination. For cross-account replication, this must be an ARN.
     * The file system's replication overwrite replication must be disabled. If no ID or ARN is specified, then a new
     * file system is created.
     * </p>
     * <note>
     * <p>
     * When you initially configure replication to an existing file system, Amazon EFS writes data to or removes
     * existing data from the destination file system to match data in the source file system. If you don't want to
     * change data in the destination file system, then you should replicate to a new file system instead. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/create-replication.html">https://docs.aws.amazon
     * .com/efs/latest/ug/create-replication.html</a>.
     * </p>
     * </note>
     * 
     * @return The ID or ARN of the file system to use for the destination. For cross-account replication, this must be
     *         an ARN. The file system's replication overwrite replication must be disabled. If no ID or ARN is
     *         specified, then a new file system is created. </p> <note>
     *         <p>
     *         When you initially configure replication to an existing file system, Amazon EFS writes data to or removes
     *         existing data from the destination file system to match data in the source file system. If you don't want
     *         to change data in the destination file system, then you should replicate to a new file system instead.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/create-replication.html">https
     *         ://docs.aws.amazon.com/efs/latest/ug/create-replication.html</a>.
     *         </p>
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform replication on
     * its behalf. This is optional for same-account replication and required for cross-account replication.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform
     *         replication on its behalf. This is optional for same-account replication and required for cross-account
     *         replication.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationToCreate)) {
            return false;
        }
        DestinationToCreate other = (DestinationToCreate) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(availabilityZoneName(), other.availabilityZoneName())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationToCreate").add("Region", region())
                .add("AvailabilityZoneName", availabilityZoneName()).add("KmsKeyId", kmsKeyId())
                .add("FileSystemId", fileSystemId()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(availabilityZoneName()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("AvailabilityZoneName", AVAILABILITY_ZONE_NAME_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationToCreate, T> g) {
        return obj -> g.apply((DestinationToCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationToCreate> {
        /**
         * <p>
         * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create
         * the destination file system. The Region must be enabled for the Amazon Web Services account that owns the
         * source file system. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Managing Amazon
         * Web Services Regions</a> in the <i>Amazon Web Services General Reference Reference Guide</i>.
         * </p>
         * 
         * @param region
         *        To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to
         *        create the destination file system. The Region must be enabled for the Amazon Web Services account
         *        that owns the source file system. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Managing
         *        Amazon Web Services Regions</a> in the <i>Amazon Web Services General Reference Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to
         * create the destination file system.
         * </p>
         * 
         * @param availabilityZoneName
         *        To create a file system that uses One Zone storage, specify the name of the Availability Zone in which
         *        to create the destination file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneName(String availabilityZoneName);

        /**
         * <p>
         * Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If
         * you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS,
         * <code>/aws/elasticfilesystem</code>. This ID can be in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID - The unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN - The ARN for the key, for example
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias ARN - The ARN for a key alias, for example
         * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file
         *        system. If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS,
         *        <code>/aws/elasticfilesystem</code>. This ID can be in one of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID - The unique identifier of the key, for example
         *        <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN - The ARN for the key, for example
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias ARN - The ARN for a key alias, for example
         *        <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ID or ARN of the file system to use for the destination. For cross-account replication, this must be an
         * ARN. The file system's replication overwrite replication must be disabled. If no ID or ARN is specified, then
         * a new file system is created.
         * </p>
         * <note>
         * <p>
         * When you initially configure replication to an existing file system, Amazon EFS writes data to or removes
         * existing data from the destination file system to match data in the source file system. If you don't want to
         * change data in the destination file system, then you should replicate to a new file system instead. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/create-replication.html">https://docs.aws.
         * amazon.com/efs/latest/ug/create-replication.html</a>.
         * </p>
         * </note>
         * 
         * @param fileSystemId
         *        The ID or ARN of the file system to use for the destination. For cross-account replication, this must
         *        be an ARN. The file system's replication overwrite replication must be disabled. If no ID or ARN is
         *        specified, then a new file system is created. </p> <note>
         *        <p>
         *        When you initially configure replication to an existing file system, Amazon EFS writes data to or
         *        removes existing data from the destination file system to match data in the source file system. If you
         *        don't want to change data in the destination file system, then you should replicate to a new file
         *        system instead. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/create-replication.html"
         *        >https://docs.aws.amazon.com/efs/latest/ug/create-replication.html</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform
         * replication on its behalf. This is optional for same-account replication and required for cross-account
         * replication.
         * </p>
         * 
         * @param roleArn
         *        Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform
         *        replication on its behalf. This is optional for same-account replication and required for
         *        cross-account replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String availabilityZoneName;

        private String kmsKeyId;

        private String fileSystemId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationToCreate model) {
            region(model.region);
            availabilityZoneName(model.availabilityZoneName);
            kmsKeyId(model.kmsKeyId);
            fileSystemId(model.fileSystemId);
            roleArn(model.roleArn);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAvailabilityZoneName() {
            return availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DestinationToCreate build() {
            return new DestinationToCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
