/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.ConnectionAuthorizationType;
import software.amazon.awssdk.services.eventbridge.model.ConnectivityResourceParameters;
import software.amazon.awssdk.services.eventbridge.model.CreateConnectionAuthRequestParameters;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, CreateConnectionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConnectionRequest.getter(CreateConnectionRequest::name)).setter(CreateConnectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConnectionRequest.getter(CreateConnectionRequest::description)).setter(CreateConnectionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationType").getter(CreateConnectionRequest.getter(CreateConnectionRequest::authorizationTypeAsString)).setter(CreateConnectionRequest.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()}).build();
    private static final SdkField<CreateConnectionAuthRequestParameters> AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthParameters").getter(CreateConnectionRequest.getter(CreateConnectionRequest::authParameters)).setter(CreateConnectionRequest.setter(Builder::authParameters)).constructor(CreateConnectionAuthRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build()}).build();
    private static final SdkField<ConnectivityResourceParameters> INVOCATION_CONNECTIVITY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvocationConnectivityParameters").getter(CreateConnectionRequest.getter(CreateConnectionRequest::invocationConnectivityParameters)).setter(CreateConnectionRequest.setter(Builder::invocationConnectivityParameters)).constructor(ConnectivityResourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationConnectivityParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, AUTHORIZATION_TYPE_FIELD, AUTH_PARAMETERS_FIELD, INVOCATION_CONNECTIVITY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String authorizationType;
    private final CreateConnectionAuthRequestParameters authParameters;
    private final ConnectivityResourceParameters invocationConnectivityParameters;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.authorizationType = builder.authorizationType;
        this.authParameters = builder.authParameters;
        this.invocationConnectivityParameters = builder.invocationConnectivityParameters;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ConnectionAuthorizationType authorizationType() {
        return ConnectionAuthorizationType.fromValue(this.authorizationType);
    }

    public final String authorizationTypeAsString() {
        return this.authorizationType;
    }

    public final CreateConnectionAuthRequestParameters authParameters() {
        return this.authParameters;
    }

    public final ConnectivityResourceParameters invocationConnectivityParameters() {
        return this.invocationConnectivityParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationConnectivityParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.authorizationTypeAsString(), other.authorizationTypeAsString()) && Objects.equals(this.authParameters(), other.authParameters()) && Objects.equals(this.invocationConnectivityParameters(), other.invocationConnectivityParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AuthorizationType", (Object)this.authorizationTypeAsString()).add("AuthParameters", (Object)this.authParameters()).add("InvocationConnectivityParameters", (Object)this.invocationConnectivityParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AuthorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationTypeAsString()));
            }
            case "AuthParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
            case "InvocationConnectivityParameters": {
                return Optional.ofNullable(clazz.cast(this.invocationConnectivityParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AuthorizationType", AUTHORIZATION_TYPE_FIELD);
        map.put("AuthParameters", AUTH_PARAMETERS_FIELD);
        map.put("InvocationConnectivityParameters", INVOCATION_CONNECTIVITY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String authorizationType;
        private CreateConnectionAuthRequestParameters authParameters;
        private ConnectivityResourceParameters invocationConnectivityParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.authorizationType(model.authorizationType);
            this.authParameters(model.authParameters);
            this.invocationConnectivityParameters(model.invocationConnectivityParameters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(ConnectionAuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final CreateConnectionAuthRequestParameters.Builder getAuthParameters() {
            return this.authParameters != null ? this.authParameters.toBuilder() : null;
        }

        public final void setAuthParameters(CreateConnectionAuthRequestParameters.BuilderImpl authParameters) {
            this.authParameters = authParameters != null ? authParameters.build() : null;
        }

        @Override
        public final Builder authParameters(CreateConnectionAuthRequestParameters authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        public final ConnectivityResourceParameters.Builder getInvocationConnectivityParameters() {
            return this.invocationConnectivityParameters != null ? this.invocationConnectivityParameters.toBuilder() : null;
        }

        public final void setInvocationConnectivityParameters(ConnectivityResourceParameters.BuilderImpl invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters != null ? invocationConnectivityParameters.build() : null;
        }

        @Override
        public final Builder invocationConnectivityParameters(ConnectivityResourceParameters invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizationType(ConnectionAuthorizationType var1);

        public Builder authParameters(CreateConnectionAuthRequestParameters var1);

        default public Builder authParameters(Consumer<CreateConnectionAuthRequestParameters.Builder> authParameters) {
            return this.authParameters((CreateConnectionAuthRequestParameters)((CreateConnectionAuthRequestParameters.Builder)CreateConnectionAuthRequestParameters.builder().applyMutation(authParameters)).build());
        }

        public Builder invocationConnectivityParameters(ConnectivityResourceParameters var1);

        default public Builder invocationConnectivityParameters(Consumer<ConnectivityResourceParameters.Builder> invocationConnectivityParameters) {
            return this.invocationConnectivityParameters((ConnectivityResourceParameters)((ConnectivityResourceParameters.Builder)ConnectivityResourceParameters.builder().applyMutation(invocationConnectivityParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

