/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.ExperimentReportS3Report;
import software.amazon.awssdk.services.fis.model.ExperimentReportS3ReportListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentReportState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentReport> {
    private static final SdkField<ExperimentReportState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ExperimentReport.getter(ExperimentReport::state)).setter(ExperimentReport.setter(Builder::state)).constructor(ExperimentReportState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<List<ExperimentReportS3Report>> S3_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Reports").getter(ExperimentReport.getter(ExperimentReport::s3Reports)).setter(ExperimentReport.setter(Builder::s3Reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentReportS3Report::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, S3_REPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExperimentReportState state;
    private final List<ExperimentReportS3Report> s3Reports;

    private ExperimentReport(BuilderImpl builder) {
        this.state = builder.state;
        this.s3Reports = builder.s3Reports;
    }

    public final ExperimentReportState state() {
        return this.state;
    }

    public final boolean hasS3Reports() {
        return this.s3Reports != null && !(this.s3Reports instanceof SdkAutoConstructList);
    }

    public final List<ExperimentReportS3Report> s3Reports() {
        return this.s3Reports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Reports() ? this.s3Reports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReport)) {
            return false;
        }
        ExperimentReport other = (ExperimentReport)obj;
        return Objects.equals(this.state(), other.state()) && this.hasS3Reports() == other.hasS3Reports() && Objects.equals(this.s3Reports(), other.s3Reports());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentReport").add("State", (Object)this.state()).add("S3Reports", this.hasS3Reports() ? this.s3Reports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "s3Reports": {
                return Optional.ofNullable(clazz.cast(this.s3Reports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", STATE_FIELD);
        map.put("s3Reports", S3_REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReport, T> g) {
        return obj -> g.apply((ExperimentReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExperimentReportState state;
        private List<ExperimentReportS3Report> s3Reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReport model) {
            this.state(model.state);
            this.s3Reports(model.s3Reports);
        }

        public final ExperimentReportState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ExperimentReportState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentReportState state) {
            this.state = state;
            return this;
        }

        public final List<ExperimentReportS3Report.Builder> getS3Reports() {
            List<ExperimentReportS3Report.Builder> result = ExperimentReportS3ReportListCopier.copyToBuilder(this.s3Reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Reports(Collection<ExperimentReportS3Report.BuilderImpl> s3Reports) {
            this.s3Reports = ExperimentReportS3ReportListCopier.copyFromBuilder(s3Reports);
        }

        @Override
        public final Builder s3Reports(Collection<ExperimentReportS3Report> s3Reports) {
            this.s3Reports = ExperimentReportS3ReportListCopier.copy(s3Reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Reports(ExperimentReportS3Report ... s3Reports) {
            this.s3Reports(Arrays.asList(s3Reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Reports(Consumer<ExperimentReportS3Report.Builder> ... s3Reports) {
            this.s3Reports(Stream.of(s3Reports).map(c -> (ExperimentReportS3Report)((ExperimentReportS3Report.Builder)ExperimentReportS3Report.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExperimentReport build() {
            return new ExperimentReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentReport> {
        public Builder state(ExperimentReportState var1);

        default public Builder state(Consumer<ExperimentReportState.Builder> state) {
            return this.state((ExperimentReportState)((ExperimentReportState.Builder)ExperimentReportState.builder().applyMutation(state)).build());
        }

        public Builder s3Reports(Collection<ExperimentReportS3Report> var1);

        public Builder s3Reports(ExperimentReportS3Report ... var1);

        public Builder s3Reports(Consumer<ExperimentReportS3Report.Builder> ... var1);
    }
}

