/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesResponse;
import software.amazon.awssdk.services.geoplaces.model.QueryRefinement;
import software.amazon.awssdk.services.geoplaces.model.QueryRefinementListCopier;
import software.amazon.awssdk.services.geoplaces.model.SuggestResultItem;
import software.amazon.awssdk.services.geoplaces.model.SuggestResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestResponse
extends GeoPlacesResponse
implements ToCopyableBuilder<Builder, SuggestResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(SuggestResponse.getter(SuggestResponse::pricingBucket)).setter(SuggestResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<SuggestResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(SuggestResponse.getter(SuggestResponse::resultItems)).setter(SuggestResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<QueryRefinement>> QUERY_REFINEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryRefinements").getter(SuggestResponse.getter(SuggestResponse::queryRefinements)).setter(SuggestResponse.setter(Builder::queryRefinements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRefinements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryRefinement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD, RESULT_ITEMS_FIELD, QUERY_REFINEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuggestResponse.memberNameToFieldInitializer();
    private final String pricingBucket;
    private final List<SuggestResultItem> resultItems;
    private final List<QueryRefinement> queryRefinements;

    private SuggestResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
        this.queryRefinements = builder.queryRefinements;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<SuggestResultItem> resultItems() {
        return this.resultItems;
    }

    public final boolean hasQueryRefinements() {
        return this.queryRefinements != null && !(this.queryRefinements instanceof SdkAutoConstructList);
    }

    public final List<QueryRefinement> queryRefinements() {
        return this.queryRefinements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryRefinements() ? this.queryRefinements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResponse)) {
            return false;
        }
        SuggestResponse other = (SuggestResponse)((Object)obj);
        return Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems()) && this.hasQueryRefinements() == other.hasQueryRefinements() && Objects.equals(this.queryRefinements(), other.queryRefinements());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestResponse").add("PricingBucket", (Object)this.pricingBucket()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).add("QueryRefinements", this.hasQueryRefinements() ? this.queryRefinements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
            case "QueryRefinements": {
                return Optional.ofNullable(clazz.cast(this.queryRefinements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        map.put("QueryRefinements", QUERY_REFINEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestResponse, T> g) {
        return obj -> g.apply((SuggestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesResponse.BuilderImpl
    implements Builder {
        private String pricingBucket;
        private List<SuggestResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();
        private List<QueryRefinement> queryRefinements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResponse model) {
            super(model);
            this.pricingBucket(model.pricingBucket);
            this.resultItems(model.resultItems);
            this.queryRefinements(model.queryRefinements);
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<SuggestResultItem.Builder> getResultItems() {
            List<SuggestResultItem.Builder> result = SuggestResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<SuggestResultItem.BuilderImpl> resultItems) {
            this.resultItems = SuggestResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<SuggestResultItem> resultItems) {
            this.resultItems = SuggestResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(SuggestResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<SuggestResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (SuggestResultItem)((SuggestResultItem.Builder)SuggestResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<QueryRefinement.Builder> getQueryRefinements() {
            List<QueryRefinement.Builder> result = QueryRefinementListCopier.copyToBuilder(this.queryRefinements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryRefinements(Collection<QueryRefinement.BuilderImpl> queryRefinements) {
            this.queryRefinements = QueryRefinementListCopier.copyFromBuilder(queryRefinements);
        }

        @Override
        public final Builder queryRefinements(Collection<QueryRefinement> queryRefinements) {
            this.queryRefinements = QueryRefinementListCopier.copy(queryRefinements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryRefinements(QueryRefinement ... queryRefinements) {
            this.queryRefinements(Arrays.asList(queryRefinements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryRefinements(Consumer<QueryRefinement.Builder> ... queryRefinements) {
            this.queryRefinements(Stream.of(queryRefinements).map(c -> (QueryRefinement)((QueryRefinement.Builder)QueryRefinement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SuggestResponse build() {
            return new SuggestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoPlacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuggestResponse> {
        public Builder pricingBucket(String var1);

        public Builder resultItems(Collection<SuggestResultItem> var1);

        public Builder resultItems(SuggestResultItem ... var1);

        public Builder resultItems(Consumer<SuggestResultItem.Builder> ... var1);

        public Builder queryRefinements(Collection<QueryRefinement> var1);

        public Builder queryRefinements(QueryRefinement ... var1);

        public Builder queryRefinements(Consumer<QueryRefinement.Builder> ... var1);
    }
}

