/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geoplaces.model.SuggestHighlights;
import software.amazon.awssdk.services.geoplaces.model.SuggestPlaceResult;
import software.amazon.awssdk.services.geoplaces.model.SuggestQueryResult;
import software.amazon.awssdk.services.geoplaces.model.SuggestResultItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuggestResultItem> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(SuggestResultItem.getter(SuggestResultItem::title)).setter(SuggestResultItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SUGGEST_RESULT_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuggestResultItemType").getter(SuggestResultItem.getter(SuggestResultItem::suggestResultItemTypeAsString)).setter(SuggestResultItem.setter(Builder::suggestResultItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestResultItemType").build()}).build();
    private static final SdkField<SuggestPlaceResult> PLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Place").getter(SuggestResultItem.getter(SuggestResultItem::place)).setter(SuggestResultItem.setter(Builder::place)).constructor(SuggestPlaceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()}).build();
    private static final SdkField<SuggestQueryResult> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Query").getter(SuggestResultItem.getter(SuggestResultItem::query)).setter(SuggestResultItem.setter(Builder::query)).constructor(SuggestQueryResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final SdkField<SuggestHighlights> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Highlights").getter(SuggestResultItem.getter(SuggestResultItem::highlights)).setter(SuggestResultItem.setter(Builder::highlights)).constructor(SuggestHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SUGGEST_RESULT_ITEM_TYPE_FIELD, PLACE_FIELD, QUERY_FIELD, HIGHLIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuggestResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String suggestResultItemType;
    private final SuggestPlaceResult place;
    private final SuggestQueryResult query;
    private final SuggestHighlights highlights;

    private SuggestResultItem(BuilderImpl builder) {
        this.title = builder.title;
        this.suggestResultItemType = builder.suggestResultItemType;
        this.place = builder.place;
        this.query = builder.query;
        this.highlights = builder.highlights;
    }

    public final String title() {
        return this.title;
    }

    public final SuggestResultItemType suggestResultItemType() {
        return SuggestResultItemType.fromValue(this.suggestResultItemType);
    }

    public final String suggestResultItemTypeAsString() {
        return this.suggestResultItemType;
    }

    public final SuggestPlaceResult place() {
        return this.place;
    }

    public final SuggestQueryResult query() {
        return this.query;
    }

    public final SuggestHighlights highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestResultItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.place());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlights());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResultItem)) {
            return false;
        }
        SuggestResultItem other = (SuggestResultItem)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.suggestResultItemTypeAsString(), other.suggestResultItemTypeAsString()) && Objects.equals(this.place(), other.place()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.highlights(), other.highlights());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestResultItem").add("Title", (Object)this.title()).add("SuggestResultItemType", (Object)this.suggestResultItemTypeAsString()).add("Place", (Object)this.place()).add("Query", (Object)this.query()).add("Highlights", (Object)this.highlights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "SuggestResultItemType": {
                return Optional.ofNullable(clazz.cast(this.suggestResultItemTypeAsString()));
            }
            case "Place": {
                return Optional.ofNullable(clazz.cast(this.place()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "Highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("SuggestResultItemType", SUGGEST_RESULT_ITEM_TYPE_FIELD);
        map.put("Place", PLACE_FIELD);
        map.put("Query", QUERY_FIELD);
        map.put("Highlights", HIGHLIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestResultItem, T> g) {
        return obj -> g.apply((SuggestResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String suggestResultItemType;
        private SuggestPlaceResult place;
        private SuggestQueryResult query;
        private SuggestHighlights highlights;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResultItem model) {
            this.title(model.title);
            this.suggestResultItemType(model.suggestResultItemType);
            this.place(model.place);
            this.query(model.query);
            this.highlights(model.highlights);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSuggestResultItemType() {
            return this.suggestResultItemType;
        }

        public final void setSuggestResultItemType(String suggestResultItemType) {
            this.suggestResultItemType = suggestResultItemType;
        }

        @Override
        public final Builder suggestResultItemType(String suggestResultItemType) {
            this.suggestResultItemType = suggestResultItemType;
            return this;
        }

        @Override
        public final Builder suggestResultItemType(SuggestResultItemType suggestResultItemType) {
            this.suggestResultItemType(suggestResultItemType == null ? null : suggestResultItemType.toString());
            return this;
        }

        public final SuggestPlaceResult.Builder getPlace() {
            return this.place != null ? this.place.toBuilder() : null;
        }

        public final void setPlace(SuggestPlaceResult.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(SuggestPlaceResult place) {
            this.place = place;
            return this;
        }

        public final SuggestQueryResult.Builder getQuery() {
            return this.query != null ? this.query.toBuilder() : null;
        }

        public final void setQuery(SuggestQueryResult.BuilderImpl query) {
            this.query = query != null ? query.build() : null;
        }

        @Override
        public final Builder query(SuggestQueryResult query) {
            this.query = query;
            return this;
        }

        public final SuggestHighlights.Builder getHighlights() {
            return this.highlights != null ? this.highlights.toBuilder() : null;
        }

        public final void setHighlights(SuggestHighlights.BuilderImpl highlights) {
            this.highlights = highlights != null ? highlights.build() : null;
        }

        @Override
        public final Builder highlights(SuggestHighlights highlights) {
            this.highlights = highlights;
            return this;
        }

        public SuggestResultItem build() {
            return new SuggestResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuggestResultItem> {
        public Builder title(String var1);

        public Builder suggestResultItemType(String var1);

        public Builder suggestResultItemType(SuggestResultItemType var1);

        public Builder place(SuggestPlaceResult var1);

        default public Builder place(Consumer<SuggestPlaceResult.Builder> place) {
            return this.place((SuggestPlaceResult)((SuggestPlaceResult.Builder)SuggestPlaceResult.builder().applyMutation(place)).build());
        }

        public Builder query(SuggestQueryResult var1);

        default public Builder query(Consumer<SuggestQueryResult.Builder> query) {
            return this.query((SuggestQueryResult)((SuggestQueryResult.Builder)SuggestQueryResult.builder().applyMutation(query)).build());
        }

        public Builder highlights(SuggestHighlights var1);

        default public Builder highlights(Consumer<SuggestHighlights.Builder> highlights) {
            return this.highlights((SuggestHighlights)((SuggestHighlights.Builder)SuggestHighlights.builder().applyMutation(highlights)).build());
        }
    }
}

