/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteFerryNoticeCode {
    ACCURATE_POLYLINE_UNAVAILABLE("AccuratePolylineUnavailable"),
    NO_SCHEDULE("NoSchedule"),
    OTHER("Other"),
    VIOLATED_AVOID_FERRY("ViolatedAvoidFerry"),
    VIOLATED_AVOID_RAIL_FERRY("ViolatedAvoidRailFerry"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteFerryNoticeCode> VALUE_MAP;
    private final String value;

    private RouteFerryNoticeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteFerryNoticeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteFerryNoticeCode> knownValues() {
        EnumSet<RouteFerryNoticeCode> knownValues = EnumSet.allOf(RouteFerryNoticeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteFerryNoticeCode.class, RouteFerryNoticeCode::toString);
    }
}

