/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointDescription;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointDescriptionsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointGroup> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointGroup.getter(EndpointGroup::endpointGroupArn)).setter(EndpointGroup.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointGroup.getter(EndpointGroup::endpointGroupRegion)).setter(EndpointGroup.setter(Builder::endpointGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build()}).build();
    private static final SdkField<List<EndpointDescription>> ENDPOINT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EndpointGroup.getter(EndpointGroup::endpointDescriptions)).setter(EndpointGroup.setter(Builder::endpointDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> TRAFFIC_DIAL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(EndpointGroup.getter(EndpointGroup::trafficDialPercentage)).setter(EndpointGroup.setter(Builder::trafficDialPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDialPercentage").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EndpointGroup.getter(EndpointGroup::healthCheckPort)).setter(EndpointGroup.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointGroup.getter(EndpointGroup::healthCheckProtocolAsString)).setter(EndpointGroup.setter(Builder::healthCheckProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointGroup.getter(EndpointGroup::healthCheckPath)).setter(EndpointGroup.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EndpointGroup.getter(EndpointGroup::healthCheckIntervalSeconds)).setter(EndpointGroup.setter(Builder::healthCheckIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build()}).build();
    private static final SdkField<Integer> THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EndpointGroup.getter(EndpointGroup::thresholdCount)).setter(EndpointGroup.setter(Builder::thresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_GROUP_REGION_FIELD, ENDPOINT_DESCRIPTIONS_FIELD, TRAFFIC_DIAL_PERCENTAGE_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, THRESHOLD_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointGroupArn;
    private final String endpointGroupRegion;
    private final List<EndpointDescription> endpointDescriptions;
    private final Float trafficDialPercentage;
    private final Integer healthCheckPort;
    private final String healthCheckProtocol;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer thresholdCount;

    private EndpointGroup(BuilderImpl builder) {
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.endpointDescriptions = builder.endpointDescriptions;
        this.trafficDialPercentage = builder.trafficDialPercentage;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.thresholdCount = builder.thresholdCount;
    }

    public String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public String endpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public boolean hasEndpointDescriptions() {
        return this.endpointDescriptions != null && !(this.endpointDescriptions instanceof SdkAutoConstructList);
    }

    public List<EndpointDescription> endpointDescriptions() {
        return this.endpointDescriptions;
    }

    public Float trafficDialPercentage() {
        return this.trafficDialPercentage;
    }

    public Integer healthCheckPort() {
        return this.healthCheckPort;
    }

    public HealthCheckProtocol healthCheckProtocol() {
        return HealthCheckProtocol.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer thresholdCount() {
        return this.thresholdCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDialPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointGroup)) {
            return false;
        }
        EndpointGroup other = (EndpointGroup)obj;
        return Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointGroupRegion(), other.endpointGroupRegion()) && Objects.equals(this.endpointDescriptions(), other.endpointDescriptions()) && Objects.equals(this.trafficDialPercentage(), other.trafficDialPercentage()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.thresholdCount(), other.thresholdCount());
    }

    public String toString() {
        return ToString.builder((String)"EndpointGroup").add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointGroupRegion", (Object)this.endpointGroupRegion()).add("EndpointDescriptions", this.endpointDescriptions()).add("TrafficDialPercentage", (Object)this.trafficDialPercentage()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("ThresholdCount", (Object)this.thresholdCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupRegion()));
            }
            case "EndpointDescriptions": {
                return Optional.ofNullable(clazz.cast(this.endpointDescriptions()));
            }
            case "TrafficDialPercentage": {
                return Optional.ofNullable(clazz.cast(this.trafficDialPercentage()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckProtocol": {
                return Optional.ofNullable(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "ThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.thresholdCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointGroup, T> g) {
        return obj -> g.apply((EndpointGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointGroupArn;
        private String endpointGroupRegion;
        private List<EndpointDescription> endpointDescriptions = DefaultSdkAutoConstructList.getInstance();
        private Float trafficDialPercentage;
        private Integer healthCheckPort;
        private String healthCheckProtocol;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer thresholdCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointGroup model) {
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointGroupRegion(model.endpointGroupRegion);
            this.endpointDescriptions(model.endpointDescriptions);
            this.trafficDialPercentage(model.trafficDialPercentage);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.thresholdCount(model.thresholdCount);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        public final String getEndpointGroupRegion() {
            return this.endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        public final Collection<EndpointDescription.Builder> getEndpointDescriptions() {
            return this.endpointDescriptions != null ? (Collection)this.endpointDescriptions.stream().map(EndpointDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointDescriptions(Collection<EndpointDescription> endpointDescriptions) {
            this.endpointDescriptions = EndpointDescriptionsCopier.copy(endpointDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(EndpointDescription ... endpointDescriptions) {
            this.endpointDescriptions(Arrays.asList(endpointDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(Consumer<EndpointDescription.Builder> ... endpointDescriptions) {
            this.endpointDescriptions(Stream.of(endpointDescriptions).map(c -> (EndpointDescription)((EndpointDescription.Builder)EndpointDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointDescriptions(Collection<EndpointDescription.BuilderImpl> endpointDescriptions) {
            this.endpointDescriptions = EndpointDescriptionsCopier.copyFromBuilder(endpointDescriptions);
        }

        public final Float getTrafficDialPercentage() {
            return this.trafficDialPercentage;
        }

        @Override
        public final Builder trafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
            return this;
        }

        public final void setTrafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
        }

        public final Integer getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckProtocolAsString() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getThresholdCount() {
            return this.thresholdCount;
        }

        @Override
        public final Builder thresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
            return this;
        }

        public final void setThresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
        }

        public EndpointGroup build() {
            return new EndpointGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointGroup> {
        public Builder endpointGroupArn(String var1);

        public Builder endpointGroupRegion(String var1);

        public Builder endpointDescriptions(Collection<EndpointDescription> var1);

        public Builder endpointDescriptions(EndpointDescription ... var1);

        public Builder endpointDescriptions(Consumer<EndpointDescription.Builder> ... var1);

        public Builder trafficDialPercentage(Float var1);

        public Builder healthCheckPort(Integer var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(HealthCheckProtocol var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder thresholdCount(Integer var1);
    }
}

