/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvertiseByoipCidrResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<AdvertiseByoipCidrResponse.Builder, AdvertiseByoipCidrResponse> {
    private static final SdkField<ByoipCidr> BYOIP_CIDR_FIELD = SdkField.<ByoipCidr> builder(MarshallingType.SDK_POJO)
            .memberName("ByoipCidr").getter(getter(AdvertiseByoipCidrResponse::byoipCidr)).setter(setter(Builder::byoipCidr))
            .constructor(ByoipCidr::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByoipCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOIP_CIDR_FIELD));

    private final ByoipCidr byoipCidr;

    private AdvertiseByoipCidrResponse(BuilderImpl builder) {
        super(builder);
        this.byoipCidr = builder.byoipCidr;
    }

    /**
     * <p>
     * Information about the address range.
     * </p>
     * 
     * @return Information about the address range.
     */
    public final ByoipCidr byoipCidr() {
        return byoipCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byoipCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvertiseByoipCidrResponse)) {
            return false;
        }
        AdvertiseByoipCidrResponse other = (AdvertiseByoipCidrResponse) obj;
        return Objects.equals(byoipCidr(), other.byoipCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvertiseByoipCidrResponse").add("ByoipCidr", byoipCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByoipCidr":
            return Optional.ofNullable(clazz.cast(byoipCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvertiseByoipCidrResponse, T> g) {
        return obj -> g.apply((AdvertiseByoipCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AdvertiseByoipCidrResponse> {
        /**
         * <p>
         * Information about the address range.
         * </p>
         * 
         * @param byoipCidr
         *        Information about the address range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byoipCidr(ByoipCidr byoipCidr);

        /**
         * <p>
         * Information about the address range.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByoipCidr.Builder} avoiding the need to
         * create one manually via {@link ByoipCidr#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByoipCidr.Builder#build()} is called immediately and its result
         * is passed to {@link #byoipCidr(ByoipCidr)}.
         * 
         * @param byoipCidr
         *        a consumer that will call methods on {@link ByoipCidr.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byoipCidr(ByoipCidr)
         */
        default Builder byoipCidr(Consumer<ByoipCidr.Builder> byoipCidr) {
            return byoipCidr(ByoipCidr.builder().applyMutation(byoipCidr).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private ByoipCidr byoipCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvertiseByoipCidrResponse model) {
            super(model);
            byoipCidr(model.byoipCidr);
        }

        public final ByoipCidr.Builder getByoipCidr() {
            return byoipCidr != null ? byoipCidr.toBuilder() : null;
        }

        public final void setByoipCidr(ByoipCidr.BuilderImpl byoipCidr) {
            this.byoipCidr = byoipCidr != null ? byoipCidr.build() : null;
        }

        @Override
        public final Builder byoipCidr(ByoipCidr byoipCidr) {
            this.byoipCidr = byoipCidr;
            return this;
        }

        @Override
        public AdvertiseByoipCidrResponse build() {
            return new AdvertiseByoipCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
