/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthenticationType;
import software.amazon.awssdk.services.glue.model.AuthenticationTypesCopier;
import software.amazon.awssdk.services.glue.model.ComputeEnvironment;
import software.amazon.awssdk.services.glue.model.ListOfStringCopier;
import software.amazon.awssdk.services.glue.model.PropertiesMapCopier;
import software.amazon.awssdk.services.glue.model.Property;
import software.amazon.awssdk.services.glue.model.PropertyNameOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeEnvironmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeEnvironmentConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::name)).setter(ComputeEnvironmentConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::description)).setter(ComputeEnvironmentConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> COMPUTE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeEnvironment").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::computeEnvironmentAsString)).setter(ComputeEnvironmentConfiguration.setter(Builder::computeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeEnvironment").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_AUTHENTICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedAuthenticationTypes").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::supportedAuthenticationTypesAsStrings)).setter(ComputeEnvironmentConfiguration.setter(Builder::supportedAuthenticationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAuthenticationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Property>> CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionOptions").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::connectionOptions)).setter(ComputeEnvironmentConfiguration.setter(Builder::connectionOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Property::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTY_NAME_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionPropertyNameOverrides").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::connectionPropertyNameOverrides)).setter(ComputeEnvironmentConfiguration.setter(Builder::connectionPropertyNameOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPropertyNameOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_OPTION_NAME_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionOptionNameOverrides").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::connectionOptionNameOverrides)).setter(ComputeEnvironmentConfiguration.setter(Builder::connectionOptionNameOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptionNameOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONNECTION_PROPERTIES_REQUIRED_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionPropertiesRequiredOverrides").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::connectionPropertiesRequiredOverrides)).setter(ComputeEnvironmentConfiguration.setter(Builder::connectionPropertiesRequiredOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPropertiesRequiredOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PHYSICAL_CONNECTION_PROPERTIES_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PhysicalConnectionPropertiesRequired").getter(ComputeEnvironmentConfiguration.getter(ComputeEnvironmentConfiguration::physicalConnectionPropertiesRequired)).setter(ComputeEnvironmentConfiguration.setter(Builder::physicalConnectionPropertiesRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionPropertiesRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, COMPUTE_ENVIRONMENT_FIELD, SUPPORTED_AUTHENTICATION_TYPES_FIELD, CONNECTION_OPTIONS_FIELD, CONNECTION_PROPERTY_NAME_OVERRIDES_FIELD, CONNECTION_OPTION_NAME_OVERRIDES_FIELD, CONNECTION_PROPERTIES_REQUIRED_OVERRIDES_FIELD, PHYSICAL_CONNECTION_PROPERTIES_REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeEnvironmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String computeEnvironment;
    private final List<String> supportedAuthenticationTypes;
    private final Map<String, Property> connectionOptions;
    private final Map<String, String> connectionPropertyNameOverrides;
    private final Map<String, String> connectionOptionNameOverrides;
    private final List<String> connectionPropertiesRequiredOverrides;
    private final Boolean physicalConnectionPropertiesRequired;

    private ComputeEnvironmentConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.computeEnvironment = builder.computeEnvironment;
        this.supportedAuthenticationTypes = builder.supportedAuthenticationTypes;
        this.connectionOptions = builder.connectionOptions;
        this.connectionPropertyNameOverrides = builder.connectionPropertyNameOverrides;
        this.connectionOptionNameOverrides = builder.connectionOptionNameOverrides;
        this.connectionPropertiesRequiredOverrides = builder.connectionPropertiesRequiredOverrides;
        this.physicalConnectionPropertiesRequired = builder.physicalConnectionPropertiesRequired;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ComputeEnvironment computeEnvironment() {
        return ComputeEnvironment.fromValue(this.computeEnvironment);
    }

    public final String computeEnvironmentAsString() {
        return this.computeEnvironment;
    }

    public final List<AuthenticationType> supportedAuthenticationTypes() {
        return AuthenticationTypesCopier.copyStringToEnum(this.supportedAuthenticationTypes);
    }

    public final boolean hasSupportedAuthenticationTypes() {
        return this.supportedAuthenticationTypes != null && !(this.supportedAuthenticationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedAuthenticationTypesAsStrings() {
        return this.supportedAuthenticationTypes;
    }

    public final boolean hasConnectionOptions() {
        return this.connectionOptions != null && !(this.connectionOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, Property> connectionOptions() {
        return this.connectionOptions;
    }

    public final boolean hasConnectionPropertyNameOverrides() {
        return this.connectionPropertyNameOverrides != null && !(this.connectionPropertyNameOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionPropertyNameOverrides() {
        return this.connectionPropertyNameOverrides;
    }

    public final boolean hasConnectionOptionNameOverrides() {
        return this.connectionOptionNameOverrides != null && !(this.connectionOptionNameOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionOptionNameOverrides() {
        return this.connectionOptionNameOverrides;
    }

    public final boolean hasConnectionPropertiesRequiredOverrides() {
        return this.connectionPropertiesRequiredOverrides != null && !(this.connectionPropertiesRequiredOverrides instanceof SdkAutoConstructList);
    }

    public final List<String> connectionPropertiesRequiredOverrides() {
        return this.connectionPropertiesRequiredOverrides;
    }

    public final Boolean physicalConnectionPropertiesRequired() {
        return this.physicalConnectionPropertiesRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedAuthenticationTypes() ? this.supportedAuthenticationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionOptions() ? this.connectionOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionPropertyNameOverrides() ? this.connectionPropertyNameOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionOptionNameOverrides() ? this.connectionOptionNameOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionPropertiesRequiredOverrides() ? this.connectionPropertiesRequiredOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionPropertiesRequired());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentConfiguration)) {
            return false;
        }
        ComputeEnvironmentConfiguration other = (ComputeEnvironmentConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.computeEnvironmentAsString(), other.computeEnvironmentAsString()) && this.hasSupportedAuthenticationTypes() == other.hasSupportedAuthenticationTypes() && Objects.equals(this.supportedAuthenticationTypesAsStrings(), other.supportedAuthenticationTypesAsStrings()) && this.hasConnectionOptions() == other.hasConnectionOptions() && Objects.equals(this.connectionOptions(), other.connectionOptions()) && this.hasConnectionPropertyNameOverrides() == other.hasConnectionPropertyNameOverrides() && Objects.equals(this.connectionPropertyNameOverrides(), other.connectionPropertyNameOverrides()) && this.hasConnectionOptionNameOverrides() == other.hasConnectionOptionNameOverrides() && Objects.equals(this.connectionOptionNameOverrides(), other.connectionOptionNameOverrides()) && this.hasConnectionPropertiesRequiredOverrides() == other.hasConnectionPropertiesRequiredOverrides() && Objects.equals(this.connectionPropertiesRequiredOverrides(), other.connectionPropertiesRequiredOverrides()) && Objects.equals(this.physicalConnectionPropertiesRequired(), other.physicalConnectionPropertiesRequired());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeEnvironmentConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ComputeEnvironment", (Object)this.computeEnvironmentAsString()).add("SupportedAuthenticationTypes", this.hasSupportedAuthenticationTypes() ? this.supportedAuthenticationTypesAsStrings() : null).add("ConnectionOptions", this.hasConnectionOptions() ? this.connectionOptions() : null).add("ConnectionPropertyNameOverrides", this.hasConnectionPropertyNameOverrides() ? this.connectionPropertyNameOverrides() : null).add("ConnectionOptionNameOverrides", this.hasConnectionOptionNameOverrides() ? this.connectionOptionNameOverrides() : null).add("ConnectionPropertiesRequiredOverrides", this.hasConnectionPropertiesRequiredOverrides() ? this.connectionPropertiesRequiredOverrides() : null).add("PhysicalConnectionPropertiesRequired", (Object)this.physicalConnectionPropertiesRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ComputeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentAsString()));
            }
            case "SupportedAuthenticationTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedAuthenticationTypesAsStrings()));
            }
            case "ConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionOptions()));
            }
            case "ConnectionPropertyNameOverrides": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertyNameOverrides()));
            }
            case "ConnectionOptionNameOverrides": {
                return Optional.ofNullable(clazz.cast(this.connectionOptionNameOverrides()));
            }
            case "ConnectionPropertiesRequiredOverrides": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertiesRequiredOverrides()));
            }
            case "PhysicalConnectionPropertiesRequired": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionPropertiesRequired()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ComputeEnvironment", COMPUTE_ENVIRONMENT_FIELD);
        map.put("SupportedAuthenticationTypes", SUPPORTED_AUTHENTICATION_TYPES_FIELD);
        map.put("ConnectionOptions", CONNECTION_OPTIONS_FIELD);
        map.put("ConnectionPropertyNameOverrides", CONNECTION_PROPERTY_NAME_OVERRIDES_FIELD);
        map.put("ConnectionOptionNameOverrides", CONNECTION_OPTION_NAME_OVERRIDES_FIELD);
        map.put("ConnectionPropertiesRequiredOverrides", CONNECTION_PROPERTIES_REQUIRED_OVERRIDES_FIELD);
        map.put("PhysicalConnectionPropertiesRequired", PHYSICAL_CONNECTION_PROPERTIES_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeEnvironmentConfiguration, T> g) {
        return obj -> g.apply((ComputeEnvironmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String computeEnvironment;
        private List<String> supportedAuthenticationTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Property> connectionOptions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> connectionPropertyNameOverrides = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> connectionOptionNameOverrides = DefaultSdkAutoConstructMap.getInstance();
        private List<String> connectionPropertiesRequiredOverrides = DefaultSdkAutoConstructList.getInstance();
        private Boolean physicalConnectionPropertiesRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.computeEnvironment(model.computeEnvironment);
            this.supportedAuthenticationTypesWithStrings(model.supportedAuthenticationTypes);
            this.connectionOptions(model.connectionOptions);
            this.connectionPropertyNameOverrides(model.connectionPropertyNameOverrides);
            this.connectionOptionNameOverrides(model.connectionOptionNameOverrides);
            this.connectionPropertiesRequiredOverrides(model.connectionPropertiesRequiredOverrides);
            this.physicalConnectionPropertiesRequired(model.physicalConnectionPropertiesRequired);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        @Override
        public final Builder computeEnvironment(ComputeEnvironment computeEnvironment) {
            this.computeEnvironment(computeEnvironment == null ? null : computeEnvironment.toString());
            return this;
        }

        public final Collection<String> getSupportedAuthenticationTypes() {
            if (this.supportedAuthenticationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedAuthenticationTypes;
        }

        public final void setSupportedAuthenticationTypes(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
        }

        @Override
        public final Builder supportedAuthenticationTypesWithStrings(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypesWithStrings(String ... supportedAuthenticationTypes) {
            this.supportedAuthenticationTypesWithStrings(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        @Override
        public final Builder supportedAuthenticationTypes(Collection<AuthenticationType> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copyEnumToString(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypes(AuthenticationType ... supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        public final Map<String, Property.Builder> getConnectionOptions() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.connectionOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionOptions(Map<String, Property.BuilderImpl> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copyFromBuilder(connectionOptions);
        }

        @Override
        public final Builder connectionOptions(Map<String, Property> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copy(connectionOptions);
            return this;
        }

        public final Map<String, String> getConnectionPropertyNameOverrides() {
            if (this.connectionPropertyNameOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionPropertyNameOverrides;
        }

        public final void setConnectionPropertyNameOverrides(Map<String, String> connectionPropertyNameOverrides) {
            this.connectionPropertyNameOverrides = PropertyNameOverridesCopier.copy(connectionPropertyNameOverrides);
        }

        @Override
        public final Builder connectionPropertyNameOverrides(Map<String, String> connectionPropertyNameOverrides) {
            this.connectionPropertyNameOverrides = PropertyNameOverridesCopier.copy(connectionPropertyNameOverrides);
            return this;
        }

        public final Map<String, String> getConnectionOptionNameOverrides() {
            if (this.connectionOptionNameOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionOptionNameOverrides;
        }

        public final void setConnectionOptionNameOverrides(Map<String, String> connectionOptionNameOverrides) {
            this.connectionOptionNameOverrides = PropertyNameOverridesCopier.copy(connectionOptionNameOverrides);
        }

        @Override
        public final Builder connectionOptionNameOverrides(Map<String, String> connectionOptionNameOverrides) {
            this.connectionOptionNameOverrides = PropertyNameOverridesCopier.copy(connectionOptionNameOverrides);
            return this;
        }

        public final Collection<String> getConnectionPropertiesRequiredOverrides() {
            if (this.connectionPropertiesRequiredOverrides instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionPropertiesRequiredOverrides;
        }

        public final void setConnectionPropertiesRequiredOverrides(Collection<String> connectionPropertiesRequiredOverrides) {
            this.connectionPropertiesRequiredOverrides = ListOfStringCopier.copy(connectionPropertiesRequiredOverrides);
        }

        @Override
        public final Builder connectionPropertiesRequiredOverrides(Collection<String> connectionPropertiesRequiredOverrides) {
            this.connectionPropertiesRequiredOverrides = ListOfStringCopier.copy(connectionPropertiesRequiredOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionPropertiesRequiredOverrides(String ... connectionPropertiesRequiredOverrides) {
            this.connectionPropertiesRequiredOverrides(Arrays.asList(connectionPropertiesRequiredOverrides));
            return this;
        }

        public final Boolean getPhysicalConnectionPropertiesRequired() {
            return this.physicalConnectionPropertiesRequired;
        }

        public final void setPhysicalConnectionPropertiesRequired(Boolean physicalConnectionPropertiesRequired) {
            this.physicalConnectionPropertiesRequired = physicalConnectionPropertiesRequired;
        }

        @Override
        public final Builder physicalConnectionPropertiesRequired(Boolean physicalConnectionPropertiesRequired) {
            this.physicalConnectionPropertiesRequired = physicalConnectionPropertiesRequired;
            return this;
        }

        public ComputeEnvironmentConfiguration build() {
            return new ComputeEnvironmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeEnvironmentConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder computeEnvironment(String var1);

        public Builder computeEnvironment(ComputeEnvironment var1);

        public Builder supportedAuthenticationTypesWithStrings(Collection<String> var1);

        public Builder supportedAuthenticationTypesWithStrings(String ... var1);

        public Builder supportedAuthenticationTypes(Collection<AuthenticationType> var1);

        public Builder supportedAuthenticationTypes(AuthenticationType ... var1);

        public Builder connectionOptions(Map<String, Property> var1);

        public Builder connectionPropertyNameOverrides(Map<String, String> var1);

        public Builder connectionOptionNameOverrides(Map<String, String> var1);

        public Builder connectionPropertiesRequiredOverrides(Collection<String> var1);

        public Builder connectionPropertiesRequiredOverrides(String ... var1);

        public Builder physicalConnectionPropertiesRequired(Boolean var1);
    }
}

