/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityRulesetEvaluationRunDescription;
import software.amazon.awssdk.services.glue.model.DataQualityRulesetEvaluationRunListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataQualityRulesetEvaluationRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListDataQualityRulesetEvaluationRunsResponse> {
    private static final SdkField<List<DataQualityRulesetEvaluationRunDescription>> RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Runs").getter(ListDataQualityRulesetEvaluationRunsResponse.getter(ListDataQualityRulesetEvaluationRunsResponse::runs)).setter(ListDataQualityRulesetEvaluationRunsResponse.setter(Builder::runs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityRulesetEvaluationRunDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataQualityRulesetEvaluationRunsResponse.getter(ListDataQualityRulesetEvaluationRunsResponse::nextToken)).setter(ListDataQualityRulesetEvaluationRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataQualityRulesetEvaluationRunsResponse.memberNameToFieldInitializer();
    private final List<DataQualityRulesetEvaluationRunDescription> runs;
    private final String nextToken;

    private ListDataQualityRulesetEvaluationRunsResponse(BuilderImpl builder) {
        super(builder);
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuns() {
        return this.runs != null && !(this.runs instanceof SdkAutoConstructList);
    }

    public final List<DataQualityRulesetEvaluationRunDescription> runs() {
        return this.runs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuns() ? this.runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityRulesetEvaluationRunsResponse)) {
            return false;
        }
        ListDataQualityRulesetEvaluationRunsResponse other = (ListDataQualityRulesetEvaluationRunsResponse)((Object)obj);
        return this.hasRuns() == other.hasRuns() && Objects.equals(this.runs(), other.runs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataQualityRulesetEvaluationRunsResponse").add("Runs", this.hasRuns() ? this.runs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Runs": {
                return Optional.ofNullable(clazz.cast(this.runs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Runs", RUNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityRulesetEvaluationRunsResponse, T> g) {
        return obj -> g.apply((ListDataQualityRulesetEvaluationRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DataQualityRulesetEvaluationRunDescription> runs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityRulesetEvaluationRunsResponse model) {
            super(model);
            this.runs(model.runs);
            this.nextToken(model.nextToken);
        }

        public final List<DataQualityRulesetEvaluationRunDescription.Builder> getRuns() {
            List<DataQualityRulesetEvaluationRunDescription.Builder> result = DataQualityRulesetEvaluationRunListCopier.copyToBuilder(this.runs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuns(Collection<DataQualityRulesetEvaluationRunDescription.BuilderImpl> runs) {
            this.runs = DataQualityRulesetEvaluationRunListCopier.copyFromBuilder(runs);
        }

        @Override
        public final Builder runs(Collection<DataQualityRulesetEvaluationRunDescription> runs) {
            this.runs = DataQualityRulesetEvaluationRunListCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(DataQualityRulesetEvaluationRunDescription ... runs) {
            this.runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<DataQualityRulesetEvaluationRunDescription.Builder> ... runs) {
            this.runs(Stream.of(runs).map(c -> (DataQualityRulesetEvaluationRunDescription)((DataQualityRulesetEvaluationRunDescription.Builder)DataQualityRulesetEvaluationRunDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataQualityRulesetEvaluationRunsResponse build() {
            return new ListDataQualityRulesetEvaluationRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataQualityRulesetEvaluationRunsResponse> {
        public Builder runs(Collection<DataQualityRulesetEvaluationRunDescription> var1);

        public Builder runs(DataQualityRulesetEvaluationRunDescription ... var1);

        public Builder runs(Consumer<DataQualityRulesetEvaluationRunDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

