/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.MetadataInfo;
import software.amazon.awssdk.services.glue.model.MetadataInfoMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuerySchemaVersionMetadataResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, QuerySchemaVersionMetadataResponse> {
    private static final SdkField<Map<String, MetadataInfo>> METADATA_INFO_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetadataInfoMap").getter(QuerySchemaVersionMetadataResponse.getter(QuerySchemaVersionMetadataResponse::metadataInfoMap)).setter(QuerySchemaVersionMetadataResponse.setter(Builder::metadataInfoMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataInfoMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(QuerySchemaVersionMetadataResponse.getter(QuerySchemaVersionMetadataResponse::schemaVersionId)).setter(QuerySchemaVersionMetadataResponse.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QuerySchemaVersionMetadataResponse.getter(QuerySchemaVersionMetadataResponse::nextToken)).setter(QuerySchemaVersionMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_INFO_MAP_FIELD, SCHEMA_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QuerySchemaVersionMetadataResponse.memberNameToFieldInitializer();
    private final Map<String, MetadataInfo> metadataInfoMap;
    private final String schemaVersionId;
    private final String nextToken;

    private QuerySchemaVersionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadataInfoMap = builder.metadataInfoMap;
        this.schemaVersionId = builder.schemaVersionId;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetadataInfoMap() {
        return this.metadataInfoMap != null && !(this.metadataInfoMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, MetadataInfo> metadataInfoMap() {
        return this.metadataInfoMap;
    }

    public final String schemaVersionId() {
        return this.schemaVersionId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataInfoMap() ? this.metadataInfoMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySchemaVersionMetadataResponse)) {
            return false;
        }
        QuerySchemaVersionMetadataResponse other = (QuerySchemaVersionMetadataResponse)((Object)obj);
        return this.hasMetadataInfoMap() == other.hasMetadataInfoMap() && Objects.equals(this.metadataInfoMap(), other.metadataInfoMap()) && Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QuerySchemaVersionMetadataResponse").add("MetadataInfoMap", this.hasMetadataInfoMap() ? this.metadataInfoMap() : null).add("SchemaVersionId", (Object)this.schemaVersionId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataInfoMap": {
                return Optional.ofNullable(clazz.cast(this.metadataInfoMap()));
            }
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetadataInfoMap", METADATA_INFO_MAP_FIELD);
        map.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuerySchemaVersionMetadataResponse, T> g) {
        return obj -> g.apply((QuerySchemaVersionMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Map<String, MetadataInfo> metadataInfoMap = DefaultSdkAutoConstructMap.getInstance();
        private String schemaVersionId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySchemaVersionMetadataResponse model) {
            super(model);
            this.metadataInfoMap(model.metadataInfoMap);
            this.schemaVersionId(model.schemaVersionId);
            this.nextToken(model.nextToken);
        }

        public final Map<String, MetadataInfo.Builder> getMetadataInfoMap() {
            Map<String, MetadataInfo.Builder> result = MetadataInfoMapCopier.copyToBuilder(this.metadataInfoMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetadataInfoMap(Map<String, MetadataInfo.BuilderImpl> metadataInfoMap) {
            this.metadataInfoMap = MetadataInfoMapCopier.copyFromBuilder(metadataInfoMap);
        }

        @Override
        public final Builder metadataInfoMap(Map<String, MetadataInfo> metadataInfoMap) {
            this.metadataInfoMap = MetadataInfoMapCopier.copy(metadataInfoMap);
            return this;
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public QuerySchemaVersionMetadataResponse build() {
            return new QuerySchemaVersionMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QuerySchemaVersionMetadataResponse> {
        public Builder metadataInfoMap(Map<String, MetadataInfo> var1);

        public Builder schemaVersionId(String var1);

        public Builder nextToken(String var1);
    }
}

