/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DirectSourceAdditionalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DirectSourceAdditionalOptions> {
    private static final SdkField<Long> BOUNDED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BoundedSize").getter(S3DirectSourceAdditionalOptions.getter(S3DirectSourceAdditionalOptions::boundedSize)).setter(S3DirectSourceAdditionalOptions.setter(Builder::boundedSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedSize").build()}).build();
    private static final SdkField<Long> BOUNDED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BoundedFiles").getter(S3DirectSourceAdditionalOptions.getter(S3DirectSourceAdditionalOptions::boundedFiles)).setter(S3DirectSourceAdditionalOptions.setter(Builder::boundedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedFiles").build()}).build();
    private static final SdkField<Boolean> ENABLE_SAMPLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableSamplePath").getter(S3DirectSourceAdditionalOptions.getter(S3DirectSourceAdditionalOptions::enableSamplePath)).setter(S3DirectSourceAdditionalOptions.setter(Builder::enableSamplePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSamplePath").build()}).build();
    private static final SdkField<String> SAMPLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamplePath").getter(S3DirectSourceAdditionalOptions.getter(S3DirectSourceAdditionalOptions::samplePath)).setter(S3DirectSourceAdditionalOptions.setter(Builder::samplePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDED_SIZE_FIELD, BOUNDED_FILES_FIELD, ENABLE_SAMPLE_PATH_FIELD, SAMPLE_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3DirectSourceAdditionalOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long boundedSize;
    private final Long boundedFiles;
    private final Boolean enableSamplePath;
    private final String samplePath;

    private S3DirectSourceAdditionalOptions(BuilderImpl builder) {
        this.boundedSize = builder.boundedSize;
        this.boundedFiles = builder.boundedFiles;
        this.enableSamplePath = builder.enableSamplePath;
        this.samplePath = builder.samplePath;
    }

    public final Long boundedSize() {
        return this.boundedSize;
    }

    public final Long boundedFiles() {
        return this.boundedFiles;
    }

    public final Boolean enableSamplePath() {
        return this.enableSamplePath;
    }

    public final String samplePath() {
        return this.samplePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundedSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSamplePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DirectSourceAdditionalOptions)) {
            return false;
        }
        S3DirectSourceAdditionalOptions other = (S3DirectSourceAdditionalOptions)obj;
        return Objects.equals(this.boundedSize(), other.boundedSize()) && Objects.equals(this.boundedFiles(), other.boundedFiles()) && Objects.equals(this.enableSamplePath(), other.enableSamplePath()) && Objects.equals(this.samplePath(), other.samplePath());
    }

    public final String toString() {
        return ToString.builder((String)"S3DirectSourceAdditionalOptions").add("BoundedSize", (Object)this.boundedSize()).add("BoundedFiles", (Object)this.boundedFiles()).add("EnableSamplePath", (Object)this.enableSamplePath()).add("SamplePath", (Object)this.samplePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundedSize": {
                return Optional.ofNullable(clazz.cast(this.boundedSize()));
            }
            case "BoundedFiles": {
                return Optional.ofNullable(clazz.cast(this.boundedFiles()));
            }
            case "EnableSamplePath": {
                return Optional.ofNullable(clazz.cast(this.enableSamplePath()));
            }
            case "SamplePath": {
                return Optional.ofNullable(clazz.cast(this.samplePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BoundedSize", BOUNDED_SIZE_FIELD);
        map.put("BoundedFiles", BOUNDED_FILES_FIELD);
        map.put("EnableSamplePath", ENABLE_SAMPLE_PATH_FIELD);
        map.put("SamplePath", SAMPLE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DirectSourceAdditionalOptions, T> g) {
        return obj -> g.apply((S3DirectSourceAdditionalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long boundedSize;
        private Long boundedFiles;
        private Boolean enableSamplePath;
        private String samplePath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DirectSourceAdditionalOptions model) {
            this.boundedSize(model.boundedSize);
            this.boundedFiles(model.boundedFiles);
            this.enableSamplePath(model.enableSamplePath);
            this.samplePath(model.samplePath);
        }

        public final Long getBoundedSize() {
            return this.boundedSize;
        }

        public final void setBoundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
        }

        @Override
        public final Builder boundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
            return this;
        }

        public final Long getBoundedFiles() {
            return this.boundedFiles;
        }

        public final void setBoundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
        }

        @Override
        public final Builder boundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
            return this;
        }

        public final Boolean getEnableSamplePath() {
            return this.enableSamplePath;
        }

        public final void setEnableSamplePath(Boolean enableSamplePath) {
            this.enableSamplePath = enableSamplePath;
        }

        @Override
        public final Builder enableSamplePath(Boolean enableSamplePath) {
            this.enableSamplePath = enableSamplePath;
            return this;
        }

        public final String getSamplePath() {
            return this.samplePath;
        }

        public final void setSamplePath(String samplePath) {
            this.samplePath = samplePath;
        }

        @Override
        public final Builder samplePath(String samplePath) {
            this.samplePath = samplePath;
            return this;
        }

        public S3DirectSourceAdditionalOptions build() {
            return new S3DirectSourceAdditionalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DirectSourceAdditionalOptions> {
        public Builder boundedSize(Long var1);

        public Builder boundedFiles(Long var1);

        public Builder enableSamplePath(Boolean var1);

        public Builder samplePath(String var1);
    }
}

