/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateStatistics> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Date").getter(DateStatistics.getter(DateStatistics::date)).setter(DateStatistics.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastGeneratedAt").getter(DateStatistics.getter(DateStatistics::lastGeneratedAt)).setter(DateStatistics.setter(Builder::lastGeneratedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()}).build();
    private static final SdkField<Double> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Severity").getter(DateStatistics.getter(DateStatistics::severity)).setter(DateStatistics.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFindings").getter(DateStatistics.getter(DateStatistics::totalFindings)).setter(DateStatistics.setter(Builder::totalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, LAST_GENERATED_AT_FIELD, SEVERITY_FIELD, TOTAL_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DateStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant date;
    private final Instant lastGeneratedAt;
    private final Double severity;
    private final Integer totalFindings;

    private DateStatistics(BuilderImpl builder) {
        this.date = builder.date;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.severity = builder.severity;
        this.totalFindings = builder.totalFindings;
    }

    public final Instant date() {
        return this.date;
    }

    public final Instant lastGeneratedAt() {
        return this.lastGeneratedAt;
    }

    public final Double severity() {
        return this.severity;
    }

    public final Integer totalFindings() {
        return this.totalFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateStatistics)) {
            return false;
        }
        DateStatistics other = (DateStatistics)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.lastGeneratedAt(), other.lastGeneratedAt()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.totalFindings(), other.totalFindings());
    }

    public final String toString() {
        return ToString.builder((String)"DateStatistics").add("Date", (Object)this.date()).add("LastGeneratedAt", (Object)this.lastGeneratedAt()).add("Severity", (Object)this.severity()).add("TotalFindings", (Object)this.totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "LastGeneratedAt": {
                return Optional.ofNullable(clazz.cast(this.lastGeneratedAt()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "TotalFindings": {
                return Optional.ofNullable(clazz.cast(this.totalFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date", DATE_FIELD);
        map.put("lastGeneratedAt", LAST_GENERATED_AT_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("totalFindings", TOTAL_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateStatistics, T> g) {
        return obj -> g.apply((DateStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private Instant lastGeneratedAt;
        private Double severity;
        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(DateStatistics model) {
            this.date(model.date);
            this.lastGeneratedAt(model.lastGeneratedAt);
            this.severity(model.severity);
            this.totalFindings(model.totalFindings);
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return this.lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Double getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getTotalFindings() {
            return this.totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public DateStatistics build() {
            return new DateStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateStatistics> {
        public Builder date(Instant var1);

        public Builder lastGeneratedAt(Instant var1);

        public Builder severity(Double var1);

        public Builder totalFindings(Integer var1);
    }
}

