/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;

public class ListGroupPoliciesIterable
implements SdkIterable<ListGroupPoliciesResponse> {
    private final IamClient client;
    private final ListGroupPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupPoliciesIterable(IamClient client, ListGroupPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupPoliciesResponseFetcher();
    }

    public Iterator<ListGroupPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> policyNames() {
        Function<ListGroupPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupPoliciesResponseFetcher
    implements SyncPageFetcher<ListGroupPoliciesResponse> {
        private ListGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListGroupPoliciesResponse nextPage(ListGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupPoliciesIterable.this.client.listGroupPolicies(ListGroupPoliciesIterable.this.firstRequest);
            }
            return ListGroupPoliciesIterable.this.client.listGroupPolicies((ListGroupPoliciesRequest)((Object)ListGroupPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

