/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> STREET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreetAddress").getter(Address.getter(Address::streetAddress)).setter(Address.setter(Builder::streetAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetAddress").build()}).build();
    private static final SdkField<String> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locality").getter(Address.getter(Address::locality)).setter(Address.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Address.getter(Address::region)).setter(Address.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(Address.getter(Address::postalCode)).setter(Address.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(Address.getter(Address::country)).setter(Address.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> FORMATTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Formatted").getter(Address.getter(Address::formatted)).setter(Address.setter(Builder::formatted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formatted").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Address.getter(Address::type)).setter(Address.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Primary").getter(Address.getter(Address::primary)).setter(Address.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREET_ADDRESS_FIELD, LOCALITY_FIELD, REGION_FIELD, POSTAL_CODE_FIELD, COUNTRY_FIELD, FORMATTED_FIELD, TYPE_FIELD, PRIMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Address.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streetAddress;
    private final String locality;
    private final String region;
    private final String postalCode;
    private final String country;
    private final String formatted;
    private final String type;
    private final Boolean primary;

    private Address(BuilderImpl builder) {
        this.streetAddress = builder.streetAddress;
        this.locality = builder.locality;
        this.region = builder.region;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
        this.formatted = builder.formatted;
        this.type = builder.type;
        this.primary = builder.primary;
    }

    public final String streetAddress() {
        return this.streetAddress;
    }

    public final String locality() {
        return this.locality;
    }

    public final String region() {
        return this.region;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String country() {
        return this.country;
    }

    public final String formatted() {
        return this.formatted;
    }

    public final String type() {
        return this.type;
    }

    public final Boolean primary() {
        return this.primary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streetAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.locality());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatted());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.streetAddress(), other.streetAddress()) && Objects.equals(this.locality(), other.locality()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.formatted(), other.formatted()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.primary(), other.primary());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("StreetAddress", (Object)(this.streetAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Locality", (Object)(this.locality() == null ? null : "*** Sensitive Data Redacted ***")).add("Region", (Object)(this.region() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Formatted", (Object)(this.formatted() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.type() == null ? null : "*** Sensitive Data Redacted ***")).add("Primary", (Object)(this.primary() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreetAddress": {
                return Optional.ofNullable(clazz.cast(this.streetAddress()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Formatted": {
                return Optional.ofNullable(clazz.cast(this.formatted()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreetAddress", STREET_ADDRESS_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Formatted", FORMATTED_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streetAddress;
        private String locality;
        private String region;
        private String postalCode;
        private String country;
        private String formatted;
        private String type;
        private Boolean primary;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.streetAddress(model.streetAddress);
            this.locality(model.locality);
            this.region(model.region);
            this.postalCode(model.postalCode);
            this.country(model.country);
            this.formatted(model.formatted);
            this.type(model.type);
            this.primary(model.primary);
        }

        public final String getStreetAddress() {
            return this.streetAddress;
        }

        public final void setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
        }

        @Override
        public final Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public final String getLocality() {
            return this.locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getFormatted() {
            return this.formatted;
        }

        public final void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        @Override
        public final Builder formatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder streetAddress(String var1);

        public Builder locality(String var1);

        public Builder region(String var1);

        public Builder postalCode(String var1);

        public Builder country(String var1);

        public Builder formatted(String var1);

        public Builder type(String var1);

        public Builder primary(Boolean var1);
    }
}

