/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;

public class ListFindingsPublisher
implements SdkPublisher<ListFindingsResponse> {
    private final InspectorAsyncClient client;
    private final ListFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsPublisher(InspectorAsyncClient client, ListFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsPublisher(InspectorAsyncClient client, ListFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFindingsResponseFetcher
    implements AsyncPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsResponse> nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsPublisher.this.client.listFindings(ListFindingsPublisher.this.firstRequest);
            }
            return ListFindingsPublisher.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

