/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeSnippetError;
import software.amazon.awssdk.services.inspector2.model.CodeSnippetErrorListCopier;
import software.amazon.awssdk.services.inspector2.model.CodeSnippetResult;
import software.amazon.awssdk.services.inspector2.model.CodeSnippetResultListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCodeSnippetResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, BatchGetCodeSnippetResponse> {
    private static final SdkField<List<CodeSnippetResult>> CODE_SNIPPET_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codeSnippetResults").getter(BatchGetCodeSnippetResponse.getter(BatchGetCodeSnippetResponse::codeSnippetResults)).setter(BatchGetCodeSnippetResponse.setter(Builder::codeSnippetResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSnippetResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSnippetResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeSnippetError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetCodeSnippetResponse.getter(BatchGetCodeSnippetResponse::errors)).setter(BatchGetCodeSnippetResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSnippetError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SNIPPET_RESULTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCodeSnippetResponse.memberNameToFieldInitializer();
    private final List<CodeSnippetResult> codeSnippetResults;
    private final List<CodeSnippetError> errors;

    private BatchGetCodeSnippetResponse(BuilderImpl builder) {
        super(builder);
        this.codeSnippetResults = builder.codeSnippetResults;
        this.errors = builder.errors;
    }

    public final boolean hasCodeSnippetResults() {
        return this.codeSnippetResults != null && !(this.codeSnippetResults instanceof SdkAutoConstructList);
    }

    public final List<CodeSnippetResult> codeSnippetResults() {
        return this.codeSnippetResults;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<CodeSnippetError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeSnippetResults() ? this.codeSnippetResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCodeSnippetResponse)) {
            return false;
        }
        BatchGetCodeSnippetResponse other = (BatchGetCodeSnippetResponse)((Object)obj);
        return this.hasCodeSnippetResults() == other.hasCodeSnippetResults() && Objects.equals(this.codeSnippetResults(), other.codeSnippetResults()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCodeSnippetResponse").add("CodeSnippetResults", this.hasCodeSnippetResults() ? this.codeSnippetResults() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeSnippetResults": {
                return Optional.ofNullable(clazz.cast(this.codeSnippetResults()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeSnippetResults", CODE_SNIPPET_RESULTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCodeSnippetResponse, T> g) {
        return obj -> g.apply((BatchGetCodeSnippetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CodeSnippetResult> codeSnippetResults = DefaultSdkAutoConstructList.getInstance();
        private List<CodeSnippetError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCodeSnippetResponse model) {
            super(model);
            this.codeSnippetResults(model.codeSnippetResults);
            this.errors(model.errors);
        }

        public final List<CodeSnippetResult.Builder> getCodeSnippetResults() {
            List<CodeSnippetResult.Builder> result = CodeSnippetResultListCopier.copyToBuilder(this.codeSnippetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSnippetResults(Collection<CodeSnippetResult.BuilderImpl> codeSnippetResults) {
            this.codeSnippetResults = CodeSnippetResultListCopier.copyFromBuilder(codeSnippetResults);
        }

        @Override
        public final Builder codeSnippetResults(Collection<CodeSnippetResult> codeSnippetResults) {
            this.codeSnippetResults = CodeSnippetResultListCopier.copy(codeSnippetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippetResults(CodeSnippetResult ... codeSnippetResults) {
            this.codeSnippetResults(Arrays.asList(codeSnippetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippetResults(Consumer<CodeSnippetResult.Builder> ... codeSnippetResults) {
            this.codeSnippetResults(Stream.of(codeSnippetResults).map(c -> (CodeSnippetResult)((CodeSnippetResult.Builder)CodeSnippetResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CodeSnippetError.Builder> getErrors() {
            List<CodeSnippetError.Builder> result = CodeSnippetErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CodeSnippetError.BuilderImpl> errors) {
            this.errors = CodeSnippetErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CodeSnippetError> errors) {
            this.errors = CodeSnippetErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CodeSnippetError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CodeSnippetError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (CodeSnippetError)((CodeSnippetError.Builder)CodeSnippetError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCodeSnippetResponse build() {
            return new BatchGetCodeSnippetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCodeSnippetResponse> {
        public Builder codeSnippetResults(Collection<CodeSnippetResult> var1);

        public Builder codeSnippetResults(CodeSnippetResult ... var1);

        public Builder codeSnippetResults(Consumer<CodeSnippetResult.Builder> ... var1);

        public Builder errors(Collection<CodeSnippetError> var1);

        public Builder errors(CodeSnippetError ... var1);

        public Builder errors(Consumer<CodeSnippetError.Builder> ... var1);
    }
}

