/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CoverageResourceType;
import software.amazon.awssdk.services.inspector2.model.ResourceScanMetadata;
import software.amazon.awssdk.services.inspector2.model.ScanMode;
import software.amazon.awssdk.services.inspector2.model.ScanStatus;
import software.amazon.awssdk.services.inspector2.model.ScanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoveredResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoveredResource> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CoveredResource.getter(CoveredResource::accountId)).setter(CoveredResource.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> LAST_SCANNED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastScannedAt").getter(CoveredResource.getter(CoveredResource::lastScannedAt)).setter(CoveredResource.setter(Builder::lastScannedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedAt").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(CoveredResource.getter(CoveredResource::resourceId)).setter(CoveredResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<ResourceScanMetadata> RESOURCE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceMetadata").getter(CoveredResource.getter(CoveredResource::resourceMetadata)).setter(CoveredResource.setter(Builder::resourceMetadata)).constructor(ResourceScanMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMetadata").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CoveredResource.getter(CoveredResource::resourceTypeAsString)).setter(CoveredResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanMode").getter(CoveredResource.getter(CoveredResource::scanModeAsString)).setter(CoveredResource.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build()}).build();
    private static final SdkField<ScanStatus> SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scanStatus").getter(CoveredResource.getter(CoveredResource::scanStatus)).setter(CoveredResource.setter(Builder::scanStatus)).constructor(ScanStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanType").getter(CoveredResource.getter(CoveredResource::scanTypeAsString)).setter(CoveredResource.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, LAST_SCANNED_AT_FIELD, RESOURCE_ID_FIELD, RESOURCE_METADATA_FIELD, RESOURCE_TYPE_FIELD, SCAN_MODE_FIELD, SCAN_STATUS_FIELD, SCAN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoveredResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Instant lastScannedAt;
    private final String resourceId;
    private final ResourceScanMetadata resourceMetadata;
    private final String resourceType;
    private final String scanMode;
    private final ScanStatus scanStatus;
    private final String scanType;

    private CoveredResource(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.lastScannedAt = builder.lastScannedAt;
        this.resourceId = builder.resourceId;
        this.resourceMetadata = builder.resourceMetadata;
        this.resourceType = builder.resourceType;
        this.scanMode = builder.scanMode;
        this.scanStatus = builder.scanStatus;
        this.scanType = builder.scanType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant lastScannedAt() {
        return this.lastScannedAt;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ResourceScanMetadata resourceMetadata() {
        return this.resourceMetadata;
    }

    public final CoverageResourceType resourceType() {
        return CoverageResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final ScanMode scanMode() {
        return ScanMode.fromValue(this.scanMode);
    }

    public final String scanModeAsString() {
        return this.scanMode;
    }

    public final ScanStatus scanStatus() {
        return this.scanStatus;
    }

    public final ScanType scanType() {
        return ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastScannedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoveredResource)) {
            return false;
        }
        CoveredResource other = (CoveredResource)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.lastScannedAt(), other.lastScannedAt()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceMetadata(), other.resourceMetadata()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scanModeAsString(), other.scanModeAsString()) && Objects.equals(this.scanStatus(), other.scanStatus()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CoveredResource").add("AccountId", (Object)this.accountId()).add("LastScannedAt", (Object)this.lastScannedAt()).add("ResourceId", (Object)this.resourceId()).add("ResourceMetadata", (Object)this.resourceMetadata()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ScanMode", (Object)this.scanModeAsString()).add("ScanStatus", (Object)this.scanStatus()).add("ScanType", (Object)this.scanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "lastScannedAt": {
                return Optional.ofNullable(clazz.cast(this.lastScannedAt()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceMetadata": {
                return Optional.ofNullable(clazz.cast(this.resourceMetadata()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "scanMode": {
                return Optional.ofNullable(clazz.cast(this.scanModeAsString()));
            }
            case "scanStatus": {
                return Optional.ofNullable(clazz.cast(this.scanStatus()));
            }
            case "scanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("lastScannedAt", LAST_SCANNED_AT_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceMetadata", RESOURCE_METADATA_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scanMode", SCAN_MODE_FIELD);
        map.put("scanStatus", SCAN_STATUS_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoveredResource, T> g) {
        return obj -> g.apply((CoveredResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Instant lastScannedAt;
        private String resourceId;
        private ResourceScanMetadata resourceMetadata;
        private String resourceType;
        private String scanMode;
        private ScanStatus scanStatus;
        private String scanType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoveredResource model) {
            this.accountId(model.accountId);
            this.lastScannedAt(model.lastScannedAt);
            this.resourceId(model.resourceId);
            this.resourceMetadata(model.resourceMetadata);
            this.resourceType(model.resourceType);
            this.scanMode(model.scanMode);
            this.scanStatus(model.scanStatus);
            this.scanType(model.scanType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getLastScannedAt() {
            return this.lastScannedAt;
        }

        public final void setLastScannedAt(Instant lastScannedAt) {
            this.lastScannedAt = lastScannedAt;
        }

        @Override
        public final Builder lastScannedAt(Instant lastScannedAt) {
            this.lastScannedAt = lastScannedAt;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final ResourceScanMetadata.Builder getResourceMetadata() {
            return this.resourceMetadata != null ? this.resourceMetadata.toBuilder() : null;
        }

        public final void setResourceMetadata(ResourceScanMetadata.BuilderImpl resourceMetadata) {
            this.resourceMetadata = resourceMetadata != null ? resourceMetadata.build() : null;
        }

        @Override
        public final Builder resourceMetadata(ResourceScanMetadata resourceMetadata) {
            this.resourceMetadata = resourceMetadata;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(CoverageResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getScanMode() {
            return this.scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final ScanStatus.Builder getScanStatus() {
            return this.scanStatus != null ? this.scanStatus.toBuilder() : null;
        }

        public final void setScanStatus(ScanStatus.BuilderImpl scanStatus) {
            this.scanStatus = scanStatus != null ? scanStatus.build() : null;
        }

        @Override
        public final Builder scanStatus(ScanStatus scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public CoveredResource build() {
            return new CoveredResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoveredResource> {
        public Builder accountId(String var1);

        public Builder lastScannedAt(Instant var1);

        public Builder resourceId(String var1);

        public Builder resourceMetadata(ResourceScanMetadata var1);

        default public Builder resourceMetadata(Consumer<ResourceScanMetadata.Builder> resourceMetadata) {
            return this.resourceMetadata((ResourceScanMetadata)((ResourceScanMetadata.Builder)ResourceScanMetadata.builder().applyMutation(resourceMetadata)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(CoverageResourceType var1);

        public Builder scanMode(String var1);

        public Builder scanMode(ScanMode var1);

        public Builder scanStatus(ScanStatus var1);

        default public Builder scanStatus(Consumer<ScanStatus.Builder> scanStatus) {
            return this.scanStatus((ScanStatus)((ScanStatus.Builder)ScanStatus.builder().applyMutation(scanStatus)).build());
        }

        public Builder scanType(String var1);

        public Builder scanType(ScanType var1);
    }
}

