/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisSessionMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisSessionMessage> {
    private static final SdkField<SdkBytes> CIS_RULE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("cisRuleDetails").getter(CisSessionMessage.getter(CisSessionMessage::cisRuleDetails)).setter(CisSessionMessage.setter(Builder::cisRuleDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cisRuleDetails").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(CisSessionMessage.getter(CisSessionMessage::ruleId)).setter(CisSessionMessage.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CisSessionMessage.getter(CisSessionMessage::statusAsString)).setter(CisSessionMessage.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIS_RULE_DETAILS_FIELD, RULE_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisSessionMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes cisRuleDetails;
    private final String ruleId;
    private final String status;

    private CisSessionMessage(BuilderImpl builder) {
        this.cisRuleDetails = builder.cisRuleDetails;
        this.ruleId = builder.ruleId;
        this.status = builder.status;
    }

    public final SdkBytes cisRuleDetails() {
        return this.cisRuleDetails;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final CisRuleStatus status() {
        return CisRuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cisRuleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisSessionMessage)) {
            return false;
        }
        CisSessionMessage other = (CisSessionMessage)obj;
        return Objects.equals(this.cisRuleDetails(), other.cisRuleDetails()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CisSessionMessage").add("CisRuleDetails", (Object)this.cisRuleDetails()).add("RuleId", (Object)this.ruleId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cisRuleDetails": {
                return Optional.ofNullable(clazz.cast(this.cisRuleDetails()));
            }
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cisRuleDetails", CIS_RULE_DETAILS_FIELD);
        map.put("ruleId", RULE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisSessionMessage, T> g) {
        return obj -> g.apply((CisSessionMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes cisRuleDetails;
        private String ruleId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CisSessionMessage model) {
            this.cisRuleDetails(model.cisRuleDetails);
            this.ruleId(model.ruleId);
            this.status(model.status);
        }

        public final ByteBuffer getCisRuleDetails() {
            return this.cisRuleDetails == null ? null : this.cisRuleDetails.asByteBuffer();
        }

        public final void setCisRuleDetails(ByteBuffer cisRuleDetails) {
            this.cisRuleDetails(cisRuleDetails == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)cisRuleDetails));
        }

        @Override
        public final Builder cisRuleDetails(SdkBytes cisRuleDetails) {
            this.cisRuleDetails = cisRuleDetails;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public CisSessionMessage build() {
            return new CisSessionMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisSessionMessage> {
        public Builder cisRuleDetails(SdkBytes var1);

        public Builder ruleId(String var1);

        public Builder status(String var1);

        public Builder status(CisRuleStatus var1);
    }
}

