/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisStringComparison {
    EQUALS("EQUALS"),
    PREFIX("PREFIX"),
    NOT_EQUALS("NOT_EQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisStringComparison> VALUE_MAP;
    private final String value;

    private CisStringComparison(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisStringComparison fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisStringComparison> knownValues() {
        EnumSet<CisStringComparison> knownValues = EnumSet.allOf(CisStringComparison.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisStringComparison.class, CisStringComparison::toString);
    }
}

