/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentVersionValue;
import software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Variable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Variable> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Variable.getter(Variable::name)).setter(Variable.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(Variable.getter(Variable::stringValue)).setter(Variable.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(Variable.getter(Variable::doubleValue)).setter(Variable.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<DatasetContentVersionValue> DATASET_CONTENT_VERSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetContentVersionValue").getter(Variable.getter(Variable::datasetContentVersionValue)).setter(Variable.setter(Builder::datasetContentVersionValue)).constructor(DatasetContentVersionValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetContentVersionValue").build()}).build();
    private static final SdkField<OutputFileUriValue> OUTPUT_FILE_URI_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputFileUriValue").getter(Variable.getter(Variable::outputFileUriValue)).setter(Variable.setter(Builder::outputFileUriValue)).constructor(OutputFileUriValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFileUriValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STRING_VALUE_FIELD, DOUBLE_VALUE_FIELD, DATASET_CONTENT_VERSION_VALUE_FIELD, OUTPUT_FILE_URI_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Variable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String stringValue;
    private final Double doubleValue;
    private final DatasetContentVersionValue datasetContentVersionValue;
    private final OutputFileUriValue outputFileUriValue;

    private Variable(BuilderImpl builder) {
        this.name = builder.name;
        this.stringValue = builder.stringValue;
        this.doubleValue = builder.doubleValue;
        this.datasetContentVersionValue = builder.datasetContentVersionValue;
        this.outputFileUriValue = builder.outputFileUriValue;
    }

    public final String name() {
        return this.name;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final DatasetContentVersionValue datasetContentVersionValue() {
        return this.datasetContentVersionValue;
    }

    public final OutputFileUriValue outputFileUriValue() {
        return this.outputFileUriValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetContentVersionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFileUriValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.datasetContentVersionValue(), other.datasetContentVersionValue()) && Objects.equals(this.outputFileUriValue(), other.outputFileUriValue());
    }

    public final String toString() {
        return ToString.builder((String)"Variable").add("Name", (Object)this.name()).add("StringValue", (Object)this.stringValue()).add("DoubleValue", (Object)this.doubleValue()).add("DatasetContentVersionValue", (Object)this.datasetContentVersionValue()).add("OutputFileUriValue", (Object)this.outputFileUriValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "datasetContentVersionValue": {
                return Optional.ofNullable(clazz.cast(this.datasetContentVersionValue()));
            }
            case "outputFileUriValue": {
                return Optional.ofNullable(clazz.cast(this.outputFileUriValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("datasetContentVersionValue", DATASET_CONTENT_VERSION_VALUE_FIELD);
        map.put("outputFileUriValue", OUTPUT_FILE_URI_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Variable, T> g) {
        return obj -> g.apply((Variable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String stringValue;
        private Double doubleValue;
        private DatasetContentVersionValue datasetContentVersionValue;
        private OutputFileUriValue outputFileUriValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Variable model) {
            this.name(model.name);
            this.stringValue(model.stringValue);
            this.doubleValue(model.doubleValue);
            this.datasetContentVersionValue(model.datasetContentVersionValue);
            this.outputFileUriValue(model.outputFileUriValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final DatasetContentVersionValue.Builder getDatasetContentVersionValue() {
            return this.datasetContentVersionValue != null ? this.datasetContentVersionValue.toBuilder() : null;
        }

        public final void setDatasetContentVersionValue(DatasetContentVersionValue.BuilderImpl datasetContentVersionValue) {
            this.datasetContentVersionValue = datasetContentVersionValue != null ? datasetContentVersionValue.build() : null;
        }

        @Override
        public final Builder datasetContentVersionValue(DatasetContentVersionValue datasetContentVersionValue) {
            this.datasetContentVersionValue = datasetContentVersionValue;
            return this;
        }

        public final OutputFileUriValue.Builder getOutputFileUriValue() {
            return this.outputFileUriValue != null ? this.outputFileUriValue.toBuilder() : null;
        }

        public final void setOutputFileUriValue(OutputFileUriValue.BuilderImpl outputFileUriValue) {
            this.outputFileUriValue = outputFileUriValue != null ? outputFileUriValue.build() : null;
        }

        @Override
        public final Builder outputFileUriValue(OutputFileUriValue outputFileUriValue) {
            this.outputFileUriValue = outputFileUriValue;
            return this;
        }

        public Variable build() {
            return new Variable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Variable> {
        public Builder name(String var1);

        public Builder stringValue(String var1);

        public Builder doubleValue(Double var1);

        public Builder datasetContentVersionValue(DatasetContentVersionValue var1);

        default public Builder datasetContentVersionValue(Consumer<DatasetContentVersionValue.Builder> datasetContentVersionValue) {
            return this.datasetContentVersionValue((DatasetContentVersionValue)((DatasetContentVersionValue.Builder)DatasetContentVersionValue.builder().applyMutation(datasetContentVersionValue)).build());
        }

        public Builder outputFileUriValue(OutputFileUriValue var1);

        default public Builder outputFileUriValue(Consumer<OutputFileUriValue.Builder> outputFileUriValue) {
            return this.outputFileUriValue((OutputFileUriValue)((OutputFileUriValue.Builder)OutputFileUriValue.builder().applyMutation(outputFileUriValue)).build());
        }
    }
}

