/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.InputSummariesCopier;
import software.amazon.awssdk.services.iotevents.model.InputSummary;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInputsResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, ListInputsResponse> {
    private static final SdkField<List<InputSummary>> INPUT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputSummaries").getter(ListInputsResponse.getter(ListInputsResponse::inputSummaries)).setter(ListInputsResponse.setter(Builder::inputSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInputsResponse.getter(ListInputsResponse::nextToken)).setter(ListInputsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInputsResponse.memberNameToFieldInitializer();
    private final List<InputSummary> inputSummaries;
    private final String nextToken;

    private ListInputsResponse(BuilderImpl builder) {
        super(builder);
        this.inputSummaries = builder.inputSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInputSummaries() {
        return this.inputSummaries != null && !(this.inputSummaries instanceof SdkAutoConstructList);
    }

    public final List<InputSummary> inputSummaries() {
        return this.inputSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSummaries() ? this.inputSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputsResponse)) {
            return false;
        }
        ListInputsResponse other = (ListInputsResponse)((Object)obj);
        return this.hasInputSummaries() == other.hasInputSummaries() && Objects.equals(this.inputSummaries(), other.inputSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInputsResponse").add("InputSummaries", this.hasInputSummaries() ? this.inputSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputSummaries": {
                return Optional.ofNullable(clazz.cast(this.inputSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputSummaries", INPUT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInputsResponse, T> g) {
        return obj -> g.apply((ListInputsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private List<InputSummary> inputSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputsResponse model) {
            super(model);
            this.inputSummaries(model.inputSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InputSummary.Builder> getInputSummaries() {
            List<InputSummary.Builder> result = InputSummariesCopier.copyToBuilder(this.inputSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSummaries(Collection<InputSummary.BuilderImpl> inputSummaries) {
            this.inputSummaries = InputSummariesCopier.copyFromBuilder(inputSummaries);
        }

        @Override
        public final Builder inputSummaries(Collection<InputSummary> inputSummaries) {
            this.inputSummaries = InputSummariesCopier.copy(inputSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSummaries(InputSummary ... inputSummaries) {
            this.inputSummaries(Arrays.asList(inputSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSummaries(Consumer<InputSummary.Builder> ... inputSummaries) {
            this.inputSummaries(Stream.of(inputSummaries).map(c -> (InputSummary)((InputSummary.Builder)InputSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputsResponse build() {
            return new ListInputsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInputsResponse> {
        public Builder inputSummaries(Collection<InputSummary> var1);

        public Builder inputSummaries(InputSummary ... var1);

        public Builder inputSummaries(Consumer<InputSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

