/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WirelessDeviceEvent {
    JOIN("Join"),
    REJOIN("Rejoin"),
    UPLINK_DATA("Uplink_Data"),
    DOWNLINK_DATA("Downlink_Data"),
    REGISTRATION("Registration"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WirelessDeviceEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessDeviceEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WirelessDeviceEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessDeviceEvent> knownValues() {
        return Stream.of(WirelessDeviceEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

