/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.ConsumerStatus;
import software.amazon.awssdk.services.kinesis.transform.ConsumerDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumerDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ConsumerDescription> {
    private final String consumerName;
    private final String consumerARN;
    private final String consumerStatus;
    private final Instant consumerCreationTimestamp;
    private final String streamARN;

    private ConsumerDescription(BuilderImpl builder) {
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
        this.consumerStatus = builder.consumerStatus;
        this.consumerCreationTimestamp = builder.consumerCreationTimestamp;
        this.streamARN = builder.streamARN;
    }

    public String consumerName() {
        return this.consumerName;
    }

    public String consumerARN() {
        return this.consumerARN;
    }

    public ConsumerStatus consumerStatus() {
        return ConsumerStatus.fromValue(this.consumerStatus);
    }

    public String consumerStatusAsString() {
        return this.consumerStatus;
    }

    public Instant consumerCreationTimestamp() {
        return this.consumerCreationTimestamp;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerDescription)) {
            return false;
        }
        ConsumerDescription other = (ConsumerDescription)obj;
        return Objects.equals(this.consumerName(), other.consumerName()) && Objects.equals(this.consumerARN(), other.consumerARN()) && Objects.equals(this.consumerStatusAsString(), other.consumerStatusAsString()) && Objects.equals(this.consumerCreationTimestamp(), other.consumerCreationTimestamp()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public String toString() {
        return ToString.builder((String)"ConsumerDescription").add("ConsumerName", (Object)this.consumerName()).add("ConsumerARN", (Object)this.consumerARN()).add("ConsumerStatus", (Object)this.consumerStatusAsString()).add("ConsumerCreationTimestamp", (Object)this.consumerCreationTimestamp()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerName": {
                return Optional.ofNullable(clazz.cast(this.consumerName()));
            }
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
            case "ConsumerStatus": {
                return Optional.ofNullable(clazz.cast(this.consumerStatusAsString()));
            }
            case "ConsumerCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.consumerCreationTimestamp()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConsumerDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String consumerName;
        private String consumerARN;
        private String consumerStatus;
        private Instant consumerCreationTimestamp;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumerDescription model) {
            this.consumerName(model.consumerName);
            this.consumerARN(model.consumerARN);
            this.consumerStatus(model.consumerStatus);
            this.consumerCreationTimestamp(model.consumerCreationTimestamp);
            this.streamARN(model.streamARN);
        }

        public final String getConsumerName() {
            return this.consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        public final String getConsumerStatus() {
            return this.consumerStatus;
        }

        @Override
        public final Builder consumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
            return this;
        }

        @Override
        public final Builder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus(consumerStatus.toString());
            return this;
        }

        public final void setConsumerStatus(String consumerStatus) {
            this.consumerStatus = consumerStatus;
        }

        public final Instant getConsumerCreationTimestamp() {
            return this.consumerCreationTimestamp;
        }

        @Override
        public final Builder consumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
            return this;
        }

        public final void setConsumerCreationTimestamp(Instant consumerCreationTimestamp) {
            this.consumerCreationTimestamp = consumerCreationTimestamp;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public ConsumerDescription build() {
            return new ConsumerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConsumerDescription> {
        public Builder consumerName(String var1);

        public Builder consumerARN(String var1);

        public Builder consumerStatus(String var1);

        public Builder consumerStatus(ConsumerStatus var1);

        public Builder consumerCreationTimestamp(Instant var1);

        public Builder streamARN(String var1);
    }
}

