/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.services.kinesis.transform.StartingPositionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartingPosition
implements StructuredPojo,
ToCopyableBuilder<Builder, StartingPosition> {
    private final String type;
    private final String sequenceNumber;
    private final Instant timestamp;

    private StartingPosition(BuilderImpl builder) {
        this.type = builder.type;
        this.sequenceNumber = builder.sequenceNumber;
        this.timestamp = builder.timestamp;
    }

    public ShardIteratorType type() {
        return ShardIteratorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartingPosition)) {
            return false;
        }
        StartingPosition other = (StartingPosition)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"StartingPosition").add("Type", (Object)this.typeAsString()).add("SequenceNumber", (Object)this.sequenceNumber()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StartingPositionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String sequenceNumber;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartingPosition model) {
            this.type(model.type);
            this.sequenceNumber(model.sequenceNumber);
            this.timestamp(model.timestamp);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardIteratorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public StartingPosition build() {
            return new StartingPosition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartingPosition> {
        public Builder type(String var1);

        public Builder type(ShardIteratorType var1);

        public Builder sequenceNumber(String var1);

        public Builder timestamp(Instant var1);
    }
}

