/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribeToShardRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, SubscribeToShardRequest> {
    private final String consumerARN;
    private final String shardId;
    private final StartingPosition startingPosition;

    private SubscribeToShardRequest(BuilderImpl builder) {
        super(builder);
        this.consumerARN = builder.consumerARN;
        this.shardId = builder.shardId;
        this.startingPosition = builder.startingPosition;
    }

    public String consumerARN() {
        return this.consumerARN;
    }

    public String shardId() {
        return this.shardId;
    }

    public StartingPosition startingPosition() {
        return this.startingPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardRequest)) {
            return false;
        }
        SubscribeToShardRequest other = (SubscribeToShardRequest)((Object)obj);
        return Objects.equals(this.consumerARN(), other.consumerARN()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.startingPosition(), other.startingPosition());
    }

    public String toString() {
        return ToString.builder((String)"SubscribeToShardRequest").add("ConsumerARN", (Object)this.consumerARN()).add("ShardId", (Object)this.shardId()).add("StartingPosition", (Object)this.startingPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerARN": {
                return Optional.ofNullable(clazz.cast(this.consumerARN()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPosition()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String consumerARN;
        private String shardId;
        private StartingPosition startingPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeToShardRequest model) {
            super(model);
            this.consumerARN(model.consumerARN);
            this.shardId(model.shardId);
            this.startingPosition(model.startingPosition);
        }

        public final String getConsumerARN() {
            return this.consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final StartingPosition.Builder getStartingPosition() {
            return this.startingPosition != null ? this.startingPosition.toBuilder() : null;
        }

        @Override
        public final Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public final void setStartingPosition(StartingPosition.BuilderImpl startingPosition) {
            this.startingPosition = startingPosition != null ? startingPosition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubscribeToShardRequest build() {
            return new SubscribeToShardRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, SubscribeToShardRequest> {
        public Builder consumerARN(String var1);

        public Builder shardId(String var1);

        public Builder startingPosition(StartingPosition var1);

        default public Builder startingPosition(Consumer<StartingPosition.Builder> startingPosition) {
            return this.startingPosition((StartingPosition)((StartingPosition.Builder)StartingPosition.builder().applyMutation(startingPosition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

