/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SplitShardRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<String> SHARDTOSPLIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardToSplit").isBinary(false).build();
    private static final MarshallingInfo<String> NEWSTARTINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewStartingHashKey").isBinary(false).build();
    private static final SplitShardRequestModelMarshaller INSTANCE = new SplitShardRequestModelMarshaller();

    private SplitShardRequestModelMarshaller() {
    }

    public static SplitShardRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SplitShardRequest splitShardRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)splitShardRequest), (String)"splitShardRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)splitShardRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)splitShardRequest.shardToSplit(), SHARDTOSPLIT_BINDING);
            protocolMarshaller.marshall((Object)splitShardRequest.newStartingHashKey(), NEWSTARTINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

