/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>ListStreams</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsResponse extends KinesisResponse implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private static final SdkField<List<String>> STREAM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListStreamsResponse::streamNames))
            .setter(setter(Builder::streamNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_MORE_STREAMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListStreamsResponse::hasMoreStreams)).setter(setter(Builder::hasMoreStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreStreams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAMES_FIELD,
            HAS_MORE_STREAMS_FIELD));

    private final List<String> streamNames;

    private final Boolean hasMoreStreams;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
    }

    /**
     * <p>
     * The names of the streams that are associated with the AWS account making the <code>ListStreams</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
     *         request.
     */
    public List<String> streamNames() {
        return streamNames;
    }

    /**
     * <p>
     * If set to <code>true</code>, there are more streams available to list.
     * </p>
     * 
     * @return If set to <code>true</code>, there are more streams available to list.
     */
    public Boolean hasMoreStreams() {
        return hasMoreStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamNames());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreStreams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return Objects.equals(streamNames(), other.streamNames()) && Objects.equals(hasMoreStreams(), other.hasMoreStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStreamsResponse").add("StreamNames", streamNames()).add("HasMoreStreams", hasMoreStreams())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamNames":
            return Optional.ofNullable(clazz.cast(streamNames()));
        case "HasMoreStreams":
            return Optional.ofNullable(clazz.cast(hasMoreStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         * request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(Collection<String> streamNames);

        /**
         * <p>
         * The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         * request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(String... streamNames);

        /**
         * <p>
         * If set to <code>true</code>, there are more streams available to list.
         * </p>
         * 
         * @param hasMoreStreams
         *        If set to <code>true</code>, there are more streams available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreStreams(Boolean hasMoreStreams);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<String> streamNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasMoreStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            streamNames(model.streamNames);
            hasMoreStreams(model.hasMoreStreams);
        }

        public final Collection<String> getStreamNames() {
            return streamNames;
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String... streamNames) {
            streamNames(Arrays.asList(streamNames));
            return this;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        public final Boolean getHasMoreStreams() {
            return hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
