/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamConsumerResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeStreamConsumerResponse.Builder, DescribeStreamConsumerResponse> {
    private static final SdkField<ConsumerDescription> CONSUMER_DESCRIPTION_FIELD = SdkField
            .<ConsumerDescription> builder(MarshallingType.SDK_POJO).memberName("ConsumerDescription")
            .getter(getter(DescribeStreamConsumerResponse::consumerDescription)).setter(setter(Builder::consumerDescription))
            .constructor(ConsumerDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_DESCRIPTION_FIELD));

    private final ConsumerDescription consumerDescription;

    private DescribeStreamConsumerResponse(BuilderImpl builder) {
        super(builder);
        this.consumerDescription = builder.consumerDescription;
    }

    /**
     * <p>
     * An object that represents the details of the consumer.
     * </p>
     * 
     * @return An object that represents the details of the consumer.
     */
    public final ConsumerDescription consumerDescription() {
        return consumerDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumerDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamConsumerResponse)) {
            return false;
        }
        DescribeStreamConsumerResponse other = (DescribeStreamConsumerResponse) obj;
        return Objects.equals(consumerDescription(), other.consumerDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamConsumerResponse").add("ConsumerDescription", consumerDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerDescription":
            return Optional.ofNullable(clazz.cast(consumerDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamConsumerResponse, T> g) {
        return obj -> g.apply((DescribeStreamConsumerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamConsumerResponse> {
        /**
         * <p>
         * An object that represents the details of the consumer.
         * </p>
         * 
         * @param consumerDescription
         *        An object that represents the details of the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerDescription(ConsumerDescription consumerDescription);

        /**
         * <p>
         * An object that represents the details of the consumer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumerDescription.Builder} avoiding the
         * need to create one manually via {@link ConsumerDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumerDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #consumerDescription(ConsumerDescription)}.
         * 
         * @param consumerDescription
         *        a consumer that will call methods on {@link ConsumerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumerDescription(ConsumerDescription)
         */
        default Builder consumerDescription(Consumer<ConsumerDescription.Builder> consumerDescription) {
            return consumerDescription(ConsumerDescription.builder().applyMutation(consumerDescription).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private ConsumerDescription consumerDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamConsumerResponse model) {
            super(model);
            consumerDescription(model.consumerDescription);
        }

        public final ConsumerDescription.Builder getConsumerDescription() {
            return consumerDescription != null ? consumerDescription.toBuilder() : null;
        }

        public final void setConsumerDescription(ConsumerDescription.BuilderImpl consumerDescription) {
            this.consumerDescription = consumerDescription != null ? consumerDescription.build() : null;
        }

        @Override
        public final Builder consumerDescription(ConsumerDescription consumerDescription) {
            this.consumerDescription = consumerDescription;
            return this;
        }

        @Override
        public DescribeStreamConsumerResponse build() {
            return new DescribeStreamConsumerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
