/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceAccessType {
    BASIC_AUTH("BASIC_AUTH"),
    VPC_SUBNET("VPC_SUBNET"),
    VPC_SECURITY_GROUP("VPC_SECURITY_GROUP"),
    SASL_SCRAM_512_AUTH("SASL_SCRAM_512_AUTH"),
    SASL_SCRAM_256_AUTH("SASL_SCRAM_256_AUTH"),
    VIRTUAL_HOST("VIRTUAL_HOST"),
    CLIENT_CERTIFICATE_TLS_AUTH("CLIENT_CERTIFICATE_TLS_AUTH"),
    SERVER_ROOT_CA_CERTIFICATE("SERVER_ROOT_CA_CERTIFICATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceAccessType> VALUE_MAP;
    private final String value;

    private SourceAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceAccessType> knownValues() {
        EnumSet<SourceAccessType> knownValues = EnumSet.allOf(SourceAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceAccessType.class, SourceAccessType::toString);
    }
}

