/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceAggregationDuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAggregatedUtterancesResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListAggregatedUtterancesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::botId)).setter(ListAggregatedUtterancesResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::botAliasId)).setter(ListAggregatedUtterancesResponse.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::botVersion)).setter(ListAggregatedUtterancesResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::localeId)).setter(ListAggregatedUtterancesResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<UtteranceAggregationDuration> AGGREGATION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationDuration").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::aggregationDuration)).setter(ListAggregatedUtterancesResponse.setter(Builder::aggregationDuration)).constructor(UtteranceAggregationDuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build()}).build();
    private static final SdkField<Instant> AGGREGATION_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("aggregationWindowStartTime").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::aggregationWindowStartTime)).setter(ListAggregatedUtterancesResponse.setter(Builder::aggregationWindowStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationWindowStartTime").build()}).build();
    private static final SdkField<Instant> AGGREGATION_WINDOW_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("aggregationWindowEndTime").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::aggregationWindowEndTime)).setter(ListAggregatedUtterancesResponse.setter(Builder::aggregationWindowEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationWindowEndTime").build()}).build();
    private static final SdkField<Instant> AGGREGATION_LAST_REFRESHED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("aggregationLastRefreshedDateTime").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::aggregationLastRefreshedDateTime)).setter(ListAggregatedUtterancesResponse.setter(Builder::aggregationLastRefreshedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationLastRefreshedDateTime").build()}).build();
    private static final SdkField<List<AggregatedUtterancesSummary>> AGGREGATED_UTTERANCES_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedUtterancesSummaries").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::aggregatedUtterancesSummaries)).setter(ListAggregatedUtterancesResponse.setter(Builder::aggregatedUtterancesSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedUtterancesSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedUtterancesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAggregatedUtterancesResponse.getter(ListAggregatedUtterancesResponse::nextToken)).setter(ListAggregatedUtterancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, AGGREGATION_DURATION_FIELD, AGGREGATION_WINDOW_START_TIME_FIELD, AGGREGATION_WINDOW_END_TIME_FIELD, AGGREGATION_LAST_REFRESHED_DATE_TIME_FIELD, AGGREGATED_UTTERANCES_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAggregatedUtterancesResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botAliasId;
    private final String botVersion;
    private final String localeId;
    private final UtteranceAggregationDuration aggregationDuration;
    private final Instant aggregationWindowStartTime;
    private final Instant aggregationWindowEndTime;
    private final Instant aggregationLastRefreshedDateTime;
    private final List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries;
    private final String nextToken;

    private ListAggregatedUtterancesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.aggregationDuration = builder.aggregationDuration;
        this.aggregationWindowStartTime = builder.aggregationWindowStartTime;
        this.aggregationWindowEndTime = builder.aggregationWindowEndTime;
        this.aggregationLastRefreshedDateTime = builder.aggregationLastRefreshedDateTime;
        this.aggregatedUtterancesSummaries = builder.aggregatedUtterancesSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final UtteranceAggregationDuration aggregationDuration() {
        return this.aggregationDuration;
    }

    public final Instant aggregationWindowStartTime() {
        return this.aggregationWindowStartTime;
    }

    public final Instant aggregationWindowEndTime() {
        return this.aggregationWindowEndTime;
    }

    public final Instant aggregationLastRefreshedDateTime() {
        return this.aggregationLastRefreshedDateTime;
    }

    public final boolean hasAggregatedUtterancesSummaries() {
        return this.aggregatedUtterancesSummaries != null && !(this.aggregatedUtterancesSummaries instanceof SdkAutoConstructList);
    }

    public final List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries() {
        return this.aggregatedUtterancesSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationWindowEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationLastRefreshedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedUtterancesSummaries() ? this.aggregatedUtterancesSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatedUtterancesResponse)) {
            return false;
        }
        ListAggregatedUtterancesResponse other = (ListAggregatedUtterancesResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.aggregationDuration(), other.aggregationDuration()) && Objects.equals(this.aggregationWindowStartTime(), other.aggregationWindowStartTime()) && Objects.equals(this.aggregationWindowEndTime(), other.aggregationWindowEndTime()) && Objects.equals(this.aggregationLastRefreshedDateTime(), other.aggregationLastRefreshedDateTime()) && this.hasAggregatedUtterancesSummaries() == other.hasAggregatedUtterancesSummaries() && Objects.equals(this.aggregatedUtterancesSummaries(), other.aggregatedUtterancesSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAggregatedUtterancesResponse").add("BotId", (Object)this.botId()).add("BotAliasId", (Object)this.botAliasId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("AggregationDuration", (Object)this.aggregationDuration()).add("AggregationWindowStartTime", (Object)this.aggregationWindowStartTime()).add("AggregationWindowEndTime", (Object)this.aggregationWindowEndTime()).add("AggregationLastRefreshedDateTime", (Object)this.aggregationLastRefreshedDateTime()).add("AggregatedUtterancesSummaries", this.hasAggregatedUtterancesSummaries() ? this.aggregatedUtterancesSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "aggregationDuration": {
                return Optional.ofNullable(clazz.cast(this.aggregationDuration()));
            }
            case "aggregationWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.aggregationWindowStartTime()));
            }
            case "aggregationWindowEndTime": {
                return Optional.ofNullable(clazz.cast(this.aggregationWindowEndTime()));
            }
            case "aggregationLastRefreshedDateTime": {
                return Optional.ofNullable(clazz.cast(this.aggregationLastRefreshedDateTime()));
            }
            case "aggregatedUtterancesSummaries": {
                return Optional.ofNullable(clazz.cast(this.aggregatedUtterancesSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("aggregationDuration", AGGREGATION_DURATION_FIELD);
        map.put("aggregationWindowStartTime", AGGREGATION_WINDOW_START_TIME_FIELD);
        map.put("aggregationWindowEndTime", AGGREGATION_WINDOW_END_TIME_FIELD);
        map.put("aggregationLastRefreshedDateTime", AGGREGATION_LAST_REFRESHED_DATE_TIME_FIELD);
        map.put("aggregatedUtterancesSummaries", AGGREGATED_UTTERANCES_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatedUtterancesResponse, T> g) {
        return obj -> g.apply((ListAggregatedUtterancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botAliasId;
        private String botVersion;
        private String localeId;
        private UtteranceAggregationDuration aggregationDuration;
        private Instant aggregationWindowStartTime;
        private Instant aggregationWindowEndTime;
        private Instant aggregationLastRefreshedDateTime;
        private List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatedUtterancesResponse model) {
            super(model);
            this.botId(model.botId);
            this.botAliasId(model.botAliasId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.aggregationDuration(model.aggregationDuration);
            this.aggregationWindowStartTime(model.aggregationWindowStartTime);
            this.aggregationWindowEndTime(model.aggregationWindowEndTime);
            this.aggregationLastRefreshedDateTime(model.aggregationLastRefreshedDateTime);
            this.aggregatedUtterancesSummaries(model.aggregatedUtterancesSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final UtteranceAggregationDuration.Builder getAggregationDuration() {
            return this.aggregationDuration != null ? this.aggregationDuration.toBuilder() : null;
        }

        public final void setAggregationDuration(UtteranceAggregationDuration.BuilderImpl aggregationDuration) {
            this.aggregationDuration = aggregationDuration != null ? aggregationDuration.build() : null;
        }

        @Override
        public final Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        public final Instant getAggregationWindowStartTime() {
            return this.aggregationWindowStartTime;
        }

        public final void setAggregationWindowStartTime(Instant aggregationWindowStartTime) {
            this.aggregationWindowStartTime = aggregationWindowStartTime;
        }

        @Override
        public final Builder aggregationWindowStartTime(Instant aggregationWindowStartTime) {
            this.aggregationWindowStartTime = aggregationWindowStartTime;
            return this;
        }

        public final Instant getAggregationWindowEndTime() {
            return this.aggregationWindowEndTime;
        }

        public final void setAggregationWindowEndTime(Instant aggregationWindowEndTime) {
            this.aggregationWindowEndTime = aggregationWindowEndTime;
        }

        @Override
        public final Builder aggregationWindowEndTime(Instant aggregationWindowEndTime) {
            this.aggregationWindowEndTime = aggregationWindowEndTime;
            return this;
        }

        public final Instant getAggregationLastRefreshedDateTime() {
            return this.aggregationLastRefreshedDateTime;
        }

        public final void setAggregationLastRefreshedDateTime(Instant aggregationLastRefreshedDateTime) {
            this.aggregationLastRefreshedDateTime = aggregationLastRefreshedDateTime;
        }

        @Override
        public final Builder aggregationLastRefreshedDateTime(Instant aggregationLastRefreshedDateTime) {
            this.aggregationLastRefreshedDateTime = aggregationLastRefreshedDateTime;
            return this;
        }

        public final List<AggregatedUtterancesSummary.Builder> getAggregatedUtterancesSummaries() {
            List<AggregatedUtterancesSummary.Builder> result = AggregatedUtterancesSummaryListCopier.copyToBuilder(this.aggregatedUtterancesSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedUtterancesSummaries(Collection<AggregatedUtterancesSummary.BuilderImpl> aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries = AggregatedUtterancesSummaryListCopier.copyFromBuilder(aggregatedUtterancesSummaries);
        }

        @Override
        public final Builder aggregatedUtterancesSummaries(Collection<AggregatedUtterancesSummary> aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries = AggregatedUtterancesSummaryListCopier.copy(aggregatedUtterancesSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedUtterancesSummaries(AggregatedUtterancesSummary ... aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries(Arrays.asList(aggregatedUtterancesSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedUtterancesSummaries(Consumer<AggregatedUtterancesSummary.Builder> ... aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries(Stream.of(aggregatedUtterancesSummaries).map(c -> (AggregatedUtterancesSummary)((AggregatedUtterancesSummary.Builder)AggregatedUtterancesSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAggregatedUtterancesResponse build() {
            return new ListAggregatedUtterancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAggregatedUtterancesResponse> {
        public Builder botId(String var1);

        public Builder botAliasId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder aggregationDuration(UtteranceAggregationDuration var1);

        default public Builder aggregationDuration(Consumer<UtteranceAggregationDuration.Builder> aggregationDuration) {
            return this.aggregationDuration((UtteranceAggregationDuration)((UtteranceAggregationDuration.Builder)UtteranceAggregationDuration.builder().applyMutation(aggregationDuration)).build());
        }

        public Builder aggregationWindowStartTime(Instant var1);

        public Builder aggregationWindowEndTime(Instant var1);

        public Builder aggregationLastRefreshedDateTime(Instant var1);

        public Builder aggregatedUtterancesSummaries(Collection<AggregatedUtterancesSummary> var1);

        public Builder aggregatedUtterancesSummaries(AggregatedUtterancesSummary ... var1);

        public Builder aggregatedUtterancesSummaries(Consumer<AggregatedUtterancesSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

