/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.EncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerSideEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerSideEncryption> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionType").getter(ServerSideEncryption.getter(ServerSideEncryption::encryptionTypeAsString)).setter(ServerSideEncryption.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsMasterKeyId").getter(ServerSideEncryption.getter(ServerSideEncryption::kmsMasterKeyId)).setter(ServerSideEncryption.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsMasterKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD, KMS_MASTER_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionType;
    private final String kmsMasterKeyId;

    private ServerSideEncryption(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSideEncryption)) {
            return false;
        }
        ServerSideEncryption other = (ServerSideEncryption)obj;
        return Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId());
    }

    public String toString() {
        return ToString.builder((String)"ServerSideEncryption").add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KmsMasterKeyId", (Object)this.kmsMasterKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "kmsMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerSideEncryption, T> g) {
        return obj -> g.apply((ServerSideEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionType;
        private String kmsMasterKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerSideEncryption model) {
            this.encryptionType(model.encryptionType);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public ServerSideEncryption build() {
            return new ServerSideEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerSideEncryption> {
        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder kmsMasterKeyId(String var1);
    }
}

