/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesRequest extends Macie2Request implements
        ToCopyableBuilder<SearchResourcesRequest.Builder, SearchResourcesRequest> {
    private static final SdkField<SearchResourcesBucketCriteria> BUCKET_CRITERIA_FIELD = SdkField
            .<SearchResourcesBucketCriteria> builder(MarshallingType.SDK_POJO).memberName("bucketCriteria")
            .getter(getter(SearchResourcesRequest::bucketCriteria)).setter(setter(Builder::bucketCriteria))
            .constructor(SearchResourcesBucketCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<SearchResourcesSortCriteria> SORT_CRITERIA_FIELD = SdkField
            .<SearchResourcesSortCriteria> builder(MarshallingType.SDK_POJO).memberName("sortCriteria")
            .getter(getter(SearchResourcesRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(SearchResourcesSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_CRITERIA_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));

    private final SearchResourcesBucketCriteria bucketCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private final SearchResourcesSortCriteria sortCriteria;

    private SearchResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.bucketCriteria = builder.bucketCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The filter conditions that determine which S3 buckets to include or exclude from the query results.
     * </p>
     * 
     * @return The filter conditions that determine which S3 buckets to include or exclude from the query results.
     */
    public final SearchResourcesBucketCriteria bucketCriteria() {
        return bucketCriteria;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of the response. The default value is 50.
     * </p>
     * 
     * @return The maximum number of items to include in each page of the response. The default value is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The nextToken string that specifies which page of results to return in a paginated response.
     * </p>
     * 
     * @return The nextToken string that specifies which page of results to return in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The criteria to use to sort the results.
     * </p>
     * 
     * @return The criteria to use to sort the results.
     */
    public final SearchResourcesSortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest) obj;
        return Objects.equals(bucketCriteria(), other.bucketCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourcesRequest").add("BucketCriteria", bucketCriteria()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortCriteria", sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketCriteria":
            return Optional.ofNullable(clazz.cast(bucketCriteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesRequest, T> g) {
        return obj -> g.apply((SearchResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourcesRequest> {
        /**
         * <p>
         * The filter conditions that determine which S3 buckets to include or exclude from the query results.
         * </p>
         * 
         * @param bucketCriteria
         *        The filter conditions that determine which S3 buckets to include or exclude from the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCriteria(SearchResourcesBucketCriteria bucketCriteria);

        /**
         * <p>
         * The filter conditions that determine which S3 buckets to include or exclude from the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchResourcesBucketCriteria.Builder}
         * avoiding the need to create one manually via {@link SearchResourcesBucketCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchResourcesBucketCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketCriteria(SearchResourcesBucketCriteria)}.
         * 
         * @param bucketCriteria
         *        a consumer that will call methods on {@link SearchResourcesBucketCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCriteria(SearchResourcesBucketCriteria)
         */
        default Builder bucketCriteria(Consumer<SearchResourcesBucketCriteria.Builder> bucketCriteria) {
            return bucketCriteria(SearchResourcesBucketCriteria.builder().applyMutation(bucketCriteria).build());
        }

        /**
         * <p>
         * The maximum number of items to include in each page of the response. The default value is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to include in each page of the response. The default value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The nextToken string that specifies which page of results to return in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string that specifies which page of results to return in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The criteria to use to sort the results.
         * </p>
         * 
         * @param sortCriteria
         *        The criteria to use to sort the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SearchResourcesSortCriteria sortCriteria);

        /**
         * <p>
         * The criteria to use to sort the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchResourcesSortCriteria.Builder}
         * avoiding the need to create one manually via {@link SearchResourcesSortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchResourcesSortCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #sortCriteria(SearchResourcesSortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link SearchResourcesSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(SearchResourcesSortCriteria)
         */
        default Builder sortCriteria(Consumer<SearchResourcesSortCriteria.Builder> sortCriteria) {
            return sortCriteria(SearchResourcesSortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private SearchResourcesBucketCriteria bucketCriteria;

        private Integer maxResults;

        private String nextToken;

        private SearchResourcesSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesRequest model) {
            super(model);
            bucketCriteria(model.bucketCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortCriteria(model.sortCriteria);
        }

        public final SearchResourcesBucketCriteria.Builder getBucketCriteria() {
            return bucketCriteria != null ? bucketCriteria.toBuilder() : null;
        }

        public final void setBucketCriteria(SearchResourcesBucketCriteria.BuilderImpl bucketCriteria) {
            this.bucketCriteria = bucketCriteria != null ? bucketCriteria.build() : null;
        }

        @Override
        public final Builder bucketCriteria(SearchResourcesBucketCriteria bucketCriteria) {
            this.bucketCriteria = bucketCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SearchResourcesSortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SearchResourcesSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SearchResourcesSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourcesRequest build() {
            return new SearchResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
