/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClassificationJobRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateClassificationJobRequest.Builder, UpdateClassificationJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(UpdateClassificationJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(UpdateClassificationJobRequest::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_ID_FIELD, JOB_STATUS_FIELD));

    private final String jobId;

    private final String jobStatus;

    private UpdateClassificationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The unique identifier for the classification job.
     * </p>
     * 
     * @return The unique identifier for the classification job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The new status for the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is
     * IDLE, PAUSED, RUNNING, or USER_PAUSED.
     * </p>
     * <p>
     * If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all
     * processing tasks for the job. You can't resume or restart a job after you cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
     * </p>
     * <p>
     * If you paused the job while it was actively running and you specify this value less than 30 days after you paused
     * the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes
     * the job according to the schedule and other settings for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED,
     * or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause
     * all processing tasks for the job.
     * </p>
     * <p>
     * If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If
     * you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires
     * and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The new status for the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current
     *         status is IDLE, PAUSED, RUNNING, or USER_PAUSED.
     *         </p>
     *         <p>
     *         If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to
     *         stop all processing tasks for the job. You can't resume or restart a job after you cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
     *         </p>
     *         <p>
     *         If you paused the job while it was actively running and you specify this value less than 30 days after
     *         you paused the job, Macie immediately resumes processing from the point where you paused the job.
     *         Otherwise, Macie resumes the job according to the schedule and other settings for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE,
     *         PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately
     *         begins to pause all processing tasks for the job.
     *         </p>
     *         <p>
     *         If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the
     *         job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the
     *         job run expires and Macie cancels the run. To check the expiration date, refer to the
     *         UserPausedDetails.jobExpiresAt property.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The new status for the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is
     * IDLE, PAUSED, RUNNING, or USER_PAUSED.
     * </p>
     * <p>
     * If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all
     * processing tasks for the job. You can't resume or restart a job after you cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
     * </p>
     * <p>
     * If you paused the job while it was actively running and you specify this value less than 30 days after you paused
     * the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes
     * the job according to the schedule and other settings for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED,
     * or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause
     * all processing tasks for the job.
     * </p>
     * <p>
     * If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If
     * you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires
     * and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The new status for the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current
     *         status is IDLE, PAUSED, RUNNING, or USER_PAUSED.
     *         </p>
     *         <p>
     *         If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to
     *         stop all processing tasks for the job. You can't resume or restart a job after you cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
     *         </p>
     *         <p>
     *         If you paused the job while it was actively running and you specify this value less than 30 days after
     *         you paused the job, Macie immediately resumes processing from the point where you paused the job.
     *         Otherwise, Macie resumes the job according to the schedule and other settings for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE,
     *         PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately
     *         begins to pause all processing tasks for the job.
     *         </p>
     *         <p>
     *         If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the
     *         job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the
     *         job run expires and Macie cancels the run. To check the expiration date, refer to the
     *         UserPausedDetails.jobExpiresAt property.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClassificationJobRequest)) {
            return false;
        }
        UpdateClassificationJobRequest other = (UpdateClassificationJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClassificationJobRequest").add("JobId", jobId()).add("JobStatus", jobStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClassificationJobRequest, T> g) {
        return obj -> g.apply((UpdateClassificationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClassificationJobRequest> {
        /**
         * <p>
         * The unique identifier for the classification job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier for the classification job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The new status for the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is
         * IDLE, PAUSED, RUNNING, or USER_PAUSED.
         * </p>
         * <p>
         * If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop
         * all processing tasks for the job. You can't resume or restart a job after you cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
         * </p>
         * <p>
         * If you paused the job while it was actively running and you specify this value less than 30 days after you
         * paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise,
         * Macie resumes the job according to the schedule and other settings for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE,
         * PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately
         * begins to pause all processing tasks for the job.
         * </p>
         * <p>
         * If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the
         * job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job
         * run expires and Macie cancels the run. To check the expiration date, refer to the
         * UserPausedDetails.jobExpiresAt property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The new status for the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current
         *        status is IDLE, PAUSED, RUNNING, or USER_PAUSED.
         *        </p>
         *        <p>
         *        If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to
         *        stop all processing tasks for the job. You can't resume or restart a job after you cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
         *        </p>
         *        <p>
         *        If you paused the job while it was actively running and you specify this value less than 30 days after
         *        you paused the job, Macie immediately resumes processing from the point where you paused the job.
         *        Otherwise, Macie resumes the job according to the schedule and other settings for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is
         *        IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie
         *        immediately begins to pause all processing tasks for the job.
         *        </p>
         *        <p>
         *        If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels
         *        the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30
         *        days, the job run expires and Macie cancels the run. To check the expiration date, refer to the
         *        UserPausedDetails.jobExpiresAt property.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The new status for the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is
         * IDLE, PAUSED, RUNNING, or USER_PAUSED.
         * </p>
         * <p>
         * If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop
         * all processing tasks for the job. You can't resume or restart a job after you cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
         * </p>
         * <p>
         * If you paused the job while it was actively running and you specify this value less than 30 days after you
         * paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise,
         * Macie resumes the job according to the schedule and other settings for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE,
         * PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately
         * begins to pause all processing tasks for the job.
         * </p>
         * <p>
         * If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the
         * job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job
         * run expires and Macie cancels the run. To check the expiration date, refer to the
         * UserPausedDetails.jobExpiresAt property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The new status for the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current
         *        status is IDLE, PAUSED, RUNNING, or USER_PAUSED.
         *        </p>
         *        <p>
         *        If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to
         *        stop all processing tasks for the job. You can't resume or restart a job after you cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.
         *        </p>
         *        <p>
         *        If you paused the job while it was actively running and you specify this value less than 30 days after
         *        you paused the job, Macie immediately resumes processing from the point where you paused the job.
         *        Otherwise, Macie resumes the job according to the schedule and other settings for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is
         *        IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie
         *        immediately begins to pause all processing tasks for the job.
         *        </p>
         *        <p>
         *        If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels
         *        the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30
         *        days, the job run expires and Macie cancels the run. To check the expiration date, refer to the
         *        UserPausedDetails.jobExpiresAt property.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String jobId;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClassificationJobRequest model) {
            super(model);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClassificationJobRequest build() {
            return new UpdateClassificationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
