/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Create maintenance setting for a flow
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddMaintenance implements SdkPojo, Serializable, ToCopyableBuilder<AddMaintenance.Builder, AddMaintenance> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDay").getter(getter(AddMaintenance::maintenanceDayAsString))
            .setter(setter(Builder::maintenanceDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()).build();

    private static final SdkField<String> MAINTENANCE_START_HOUR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceStartHour").getter(getter(AddMaintenance::maintenanceStartHour))
            .setter(setter(Builder::maintenanceStartHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartHour").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD,
            MAINTENANCE_START_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maintenanceDay;

    private final String maintenanceStartHour;

    private AddMaintenance(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceStartHour = builder.maintenanceStartHour;
    }

    /**
     * A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return A day of a week when the maintenance will happen. Use
     *         Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * @see MaintenanceDay
     */
    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(maintenanceDay);
    }

    /**
     * A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return A day of a week when the maintenance will happen. Use
     *         Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * @see MaintenanceDay
     */
    public final String maintenanceDayAsString() {
        return maintenanceDay;
    }

    /**
     * UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The
     * default value is 02:00.
     * 
     * @return UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00.
     *         The default value is 02:00.
     */
    public final String maintenanceStartHour() {
        return maintenanceStartHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceStartHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddMaintenance)) {
            return false;
        }
        AddMaintenance other = (AddMaintenance) obj;
        return Objects.equals(maintenanceDayAsString(), other.maintenanceDayAsString())
                && Objects.equals(maintenanceStartHour(), other.maintenanceStartHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddMaintenance").add("MaintenanceDay", maintenanceDayAsString())
                .add("MaintenanceStartHour", maintenanceStartHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceDay":
            return Optional.ofNullable(clazz.cast(maintenanceDayAsString()));
        case "MaintenanceStartHour":
            return Optional.ofNullable(clazz.cast(maintenanceStartHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddMaintenance, T> g) {
        return obj -> g.apply((AddMaintenance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddMaintenance> {
        /**
         * A day of a week when the maintenance will happen. Use
         * Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * 
         * @param maintenanceDay
         *        A day of a week when the maintenance will happen. Use
         *        Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(String maintenanceDay);

        /**
         * A day of a week when the maintenance will happen. Use
         * Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * 
         * @param maintenanceDay
         *        A day of a week when the maintenance will happen. Use
         *        Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(MaintenanceDay maintenanceDay);

        /**
         * UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The
         * default value is 02:00.
         * 
         * @param maintenanceStartHour
         *        UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example:
         *        13:00. The default value is 02:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceStartHour(String maintenanceStartHour);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceDay;

        private String maintenanceStartHour;

        private BuilderImpl() {
        }

        private BuilderImpl(AddMaintenance model) {
            maintenanceDay(model.maintenanceDay);
            maintenanceStartHour(model.maintenanceStartHour);
        }

        public final String getMaintenanceDay() {
            return maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceStartHour() {
            return maintenanceStartHour;
        }

        public final void setMaintenanceStartHour(String maintenanceStartHour) {
            this.maintenanceStartHour = maintenanceStartHour;
        }

        @Override
        public final Builder maintenanceStartHour(String maintenanceStartHour) {
            this.maintenanceStartHour = maintenanceStartHour;
            return this;
        }

        @Override
        public AddMaintenance build() {
            return new AddMaintenance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
