/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.DescribeClusterSummary;
import software.amazon.awssdk.services.medialive.model.ListClustersRequest;
import software.amazon.awssdk.services.medialive.model.ListClustersResponse;

public class ListClustersIterable
implements SdkIterable<ListClustersResponse> {
    private final MediaLiveClient client;
    private final ListClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersIterable(MediaLiveClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeClusterSummary> clusters() {
        Function<ListClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClustersResponseFetcher
    implements SyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersIterable.this.client.listClusters(ListClustersIterable.this.firstRequest);
            }
            return ListClustersIterable.this.client.listClusters((ListClustersRequest)((Object)ListClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

